/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Gopher-Typen
 * Copyright (c) 2025 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GOPHERTYP_H
#define GOPHERTYP_H

// Gopher-Typen (RFC 1436)
#define TYP_TEXT	'0'
#define TYP_MENUE	'1'
#define TYP_CCSO	'2'	// CCSO Nameserver (RFC 2378)
#define TYP_FEHLER	'3'
#define TYP_BINHEX	'4'
#define TYP_ARCHIV	'5'
#define TYP_UUE		'6'	// uuencode (POSIX)
#define TYP_SUCHE	'7'
#define TYP_TELNET	'8'	// Teletype Network (RFC 854,855,...)
#define TYP_BINAER	'9'
#define TYP_ALT		'+'	// Alternativer Server
#define TYP_GIF		'g'
#define TYP_BILD	'I'
#define TYP_TN3270	'T'	// RFC 1041, 1576, 2355

// Gopher+
#define TYP_BITMAP	':'	// nicht aktiv verwenden
#define TYP_VIDEO	';'
#define TYP_TON		'<'	// nicht aktiv verwenden

// Erweiterungen
#define TYP_DOKU	'd'
#define TYP_HTML	'h'
#define TYP_INFO	'i'
#define TYP_AUDIO	's'
#define TYP_XML		'X'
#define TYP_MIME	'M'
#define TYP_KALENDER	'c'	// iCalendar (RFC 5545)

#define TYP_PNG		'p'	// nicht aktiv verwenden
#define TYP_RTF		'r'	// nicht aktiv verwenden
#define TYP_PDF		'P'	// nicht aktiv verwenden

#endif
