/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2024-2025 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// siehe RFC 1436

#include <string.h>
#include <errno.h>
#include <sys/socket.h>
#include "akfnetz.h"

extern int
akfnetz_Gopher_Selektor (int Verbindung, const char *Selektor)
{
  if (!Selektor)
    Selektor = "";

  size_t l = strlen (Selektor);
  char z[l + 3];
  if (l != 0)
    memcpy (z, Selektor, l);
  memcpy (z + l, "\r\n", 3);
  l += 2;

  ssize_t r;
  do
    r = send (Verbindung, z, l, 0);
  while (r < 0 && errno == EINTR);

  if (r < 0)
    return -1;

  return Verbindung;
}
