/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2015,2016 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include "akfnetz.h"

// dies ist die wohl haesslichste Warze von HTTP

uintmax_t
akfnetz_gestueckelt (FILE * d,
		     int (*Teilausgabe) (void *, size_t, void *),
		     void *Nutzerdaten)
{
  char Zeile[1024];
  void *Puffer = NULL;
  ssize_t Pufferlaenge = 0, Blocklaenge = 0;
  uintmax_t gesamt = 0;
  int Fehler = 0;

  do
    {
      // Blocklaenge lesen
      if (!fgets (Zeile, sizeof (Zeile), d))
	{
	  Fehler = -1;
	  break;
	}


      Blocklaenge = (ssize_t) strtol (Zeile, NULL, 16);

      if (Blocklaenge > Pufferlaenge)
	{
	  void *p = realloc (Puffer, Blocklaenge);
	  if (!p)
	    break;

	  Puffer = p;
	  Pufferlaenge = Blocklaenge;
	}

      if (Blocklaenge > 0)
	{
	  size_t Rest = Blocklaenge;

	  do
	    {
	      size_t n;

	      n = fread (Puffer, 1, Rest, d);

	      if (!n)
		{
		  Fehler = -1;
		  break;
		}

	      gesamt += n;
	      Rest -= n;

	      if (Teilausgabe && !Fehler)
		Fehler = Teilausgabe (Puffer, n, Nutzerdaten);
	    }
	  while (Rest > 0 && !Fehler);

	  // Zeilenende ueberspringen
	  fgets (Zeile, sizeof (Zeile), d);
	}
    }
  while (Blocklaenge != 0);

  free (Puffer);

  if (Fehler)
    gesamt = 0;

  return gesamt;
}
