/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2024 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "akfnetz.h"
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

static ssize_t
lies (int d, void *p, size_t l)
{
  ssize_t r;

  do
    r = read (d, p, l);
  while (r < 0 && errno == EINTR);

  return r;
}


extern size_t
akfnetz_einlesen (int d, char **Ergebnis)
{
  char *Puffer;
  size_t Laenge, Kapazitaet;
  ssize_t r;
  char p[8192];

  if (!Ergebnis)
    return 0;

  *Ergebnis = NULL;

  Laenge = 0;
  Kapazitaet = sizeof (p);
  Puffer = malloc (Kapazitaet + 1);
  if (!Puffer)
    return 0;

  while ((r = lies (d, p, sizeof (p))) > 0)
    {
      if ((Laenge + r) > Kapazitaet)
	{
	  Kapazitaet *= 2;
	  char *n = realloc (Puffer, Kapazitaet + 1);
	  if (!n)
	    break;
	  Puffer = n;
	}

      memcpy (Puffer + Laenge, p, r);
      Laenge += r;
    }

  if (r < 0 || !Laenge)
    {
      free (Puffer);
      return 0;
    }

  Puffer[Laenge] = '\0';
  *Ergebnis = Puffer;

  return Laenge;
}
