/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2024 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include "akfnetz.h"

static char *var (const char *);

extern bool
akfnetz_deutschsprachig (void)
{
  char *p;

  if (!(p = var ("LC_ALL")) && !(p = var ("LC_MESSAGES"))
      && !(p = var ("LANG")))
    p = "C";

  return (!strncmp (p, "de", 2));
}


static char *
var (const char *n)
{
  char *e = getenv (n);

  if (e && !*e)
    e = NULL;

  return e;
}
