/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2018 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "akfnetz.h"


extern int
akfnetz_daemonisieren (void)
{
  pid_t p = fork ();
  if (p < 0)
    return -1;

  if (p > 0)
    _exit (EXIT_SUCCESS);

  setsid ();

  // Standard Ein-/Ausgabe umleiten
  int n = open ("/dev/null", O_RDWR | O_NOCTTY);
  if (n < 0)
    return -1;

  dup2 (n, STDIN_FILENO);
  dup2 (n, STDOUT_FILENO);
  dup2 (n, STDERR_FILENO);

  if (n > STDERR_FILENO)
    close (n);

  return 0;
}
