/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2019,2021-2022 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <uchar.h>
#include "akfnetz.h"

// Zeichen 0x80-0x9F von Codepage 1252
static const char16_t cp1252[32] = {
  0x20AC, 0xFFFD, 0x201A, 0x0192, 0x201E, 0x2026, 0x2020, 0x2021,
  0x02C6, 0x2030, 0x0160, 0x2039, 0x0152, 0xFFFD, 0x017D, 0xFFFD,
  0xFFFD, 0x2018, 0x2019, 0x201C, 0x201D, 0x2022, 0x2013, 0x2014,
  0x02DC, 0x2122, 0x0161, 0x203A, 0x0153, 0xFFFD, 0x017E, 0x0178
};


extern char32_t
akfnetz_cp1252 (int c)
{
  unsigned char z;

  z = (unsigned char) c;

  if (0x80 <= z && z <= 0x9F)
    return (cp1252[z & 0x1F]);

  // alles andere entspricht Unicode
  return z;
}
