#!/bin/sh

# Lizenz: CC0
# https://creativecommons.org/publicdomain/zero/1.0/deed.de
# SPDX-License-Identifier: CC0-1.0

# Fehlerseiten sollten einen passenden Statuscode mitliefern
# Status 451 ist in RFC 7725 beschrieben

#echo "Status: 410 Gone"
echo "Status: 451 Unavailable For Legal Reasons"

echo "Content-Type: text/html; charset=UTF-8"
echo

test "$REQUEST_METHOD" = "HEAD" && exit

cat <<ENDE
<!DOCTYPE html>
<html lang="de">
<head>
<title>Verboten</title>
<meta name="viewport" content="width=device-width">
<link rel="stylesheet" type="text/css" href="/.well-known/akfnetz/Fehler.css">
</head>

<body><div id="Fehler">
<div id="schliessen"><a href="${HTTP_REFERER:-/}">&#xD7;</a></div>

<h1>&#x2639; Verboten</h1>

<p>
Wir bedauern mitteilen zu müssen,
dass wir diesen Inhalt
aus rechtlichen Gründen
nicht mehr öffentlich auf ${SERVER_NAME:-diesem Server}
zur Verfügung stellen dürfen.
</p>

</div>
</body></html>
ENDE
