/* SPDX-License-Identifier: CC0-1.0 */
/*
Lizenz: CC0
https://creativecommons.org/publicdomain/zero/1.0/deed.de
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

extern char **environ;
static void CGI_Texteinleitung (void);

int
main (int argc, char **argv)
{
  char **e;
  int i;

  CGI_Texteinleitung ();

  /* CGI-Programm */
  fputs (argv[0], stdout);

  /* Kommandozeilenparameter, falls vorhanden */
  for (i = 1; i < argc; ++i)
    {
      fputs (" \"", stdout);
      fputs (argv[i], stdout);
      putchar ('"');
    }

  puts ("\n");

  for (e = environ; *e; e++)
    puts (*e);

  return 0;
}


/*
 * Falls es als CGI aufgerufen wurde, wird ein CGI-Kopf ausgegeben,
 * und wenn es eine HEAD-Anfrage war, wird das Programm beendet.
 */
static void
CGI_Texteinleitung (void)
{
  char *m;

  m = getenv ("REQUEST_METHOD");
  if (!m || !getenv ("GATEWAY_INTERFACE"))
    return;

  fputs ("Content-Type: text/plain; charset=UTF-8\n\n", stdout);

  if (!strcmp (m, "HEAD"))
    exit (0);
}
