---------------------------------------------------------------------------
-- CGI                                                                   --
-- Copyright (c) 2019-2020 Andreas K. Foerster <akf@akfoerster.de>       --
--                                                                       --
-- This program is free software: you can redistribute it and/or modify  --
-- it under the terms of the GNU General Public License as published by  --
-- the Free Software Foundation, either version 3 of the License, or     --
-- (at your option) any later version.                                   --
--                                                                       --
-- This program is distributed in the hope that it will be useful,       --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of        --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         --
-- GNU General Public License for more details.                          --
--                                                                       --
-- You should have received a copy of the GNU General Public License     --
-- along with this program.  If not, see <http://www.gnu.org/licenses/>. --
---------------------------------------------------------------------------

-- SPDX-License-Identifier: GPL-3.0-or-later
pragma License (Gpl);
pragma Ada_2005;

package CGI is

   type Method_Type is (Get, Head, Post);

   Header_Sent    : Boolean         := False;
   Default_Header : constant String :=
     "Content-Type: text/html; charset=UTF-8";

   procedure HTML_Text (Item : String);

   function Value (Key : String) return String;
   function Key_Exists (Key : String) return Boolean;

   function Value (Position : Positive) return String;
   function Key (Position : Positive) return String;

   function Argument_Count return Natural;

   procedure Put_Header (Header : String := Default_Header);

   function Method return Method_Type;

   generic
      with procedure Action
        (Key      : in     String;
         Value    : in     String;
         Position : in     Positive;
         Quit     : in out Boolean);
   procedure For_Every_Parameter;

   function Metavariable (Name : String) return String;
   function Metavariable_Exists (Name : String) return Boolean;

end CGI;
