#!/usr/bin/lua
--[[-------------------------------------------------------------------
Beispiel fuer akfcgi.lua
Copyright (c) 2019 Andreas K. Foerster <akf@akfoerster.de>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

SPDX-License-Identifier: GPL-3.0-or-later
--]]-------------------------------------------------------------------

local cgi = require "akfcgi"

local Titel = "Lua-Beispielformular"

local Stil = [[
body {
  font-size:x-large; max-width:50em;
  margin:2ex auto; padding:.5em;
  display:table
  }

  blockquote {
    padding-left:1em;
    border-left:solid .7ex #ccc;
  }
]]


local Verarbeitung = function ()
  --[[
  Dies ist nur ein Beispiel.
  Man koennte es zB. auch per E-Mail verschicken,
  oder irgendwo speichern...
  ]]

  cgi.write ("\n<hr/>\n<h2>Felder:</h2>\n")

  cgi.write ("<dl>\n")

  for k, v in pairs (cgi.form) do
    if type (v) == "table" then v = table.concat (v, ", ") end

    cgi.write ("<dt>", cgi.htmltext (k), "</dt><dd>",
               cgi.htmltext (v), "</dd>\n")
  end

  cgi.write ("</dl>\n")
end


local HTML_Anfang = function (t)
  cgi.write ("<!DOCTYPE html>\n<html>\n<head>\n",
             "<meta charset='UTF-8' />\n<title>", t, "</title>\n<style>\n",
             Stil, "</style>\n</head>\n\n<body>\n")
end


local Auswertung = function ()
  cgi.Kopf ()

  HTML_Anfang (Titel)

  if cgi.form.Name and cgi.form.Name ~= "" then
      cgi.write ("<h1>")
      if not cgi.form.Anrede or cgi.form.Anrede == "formlos" then
	cgi.write ("Hallo ")
      elseif cgi.form.Anrede == "Frau" then
	cgi.write ("Sehr geehrte Frau ")
      else
	cgi.write ("Sehr geehrter Herr ")
      end

      cgi.write (cgi.htmltext (cgi.form.Name), ",</h1>\n\n")
   end

  --[[
  Niemals Daten aus Formularen direkt in (X)HTML einfuegen!
  Ein Angreifer koennte sonst Code einschleusen.
  Dafuer sind die Funktionen cgi.htmltext() und cgi.text() da.
  ]]

  cgi.write ("<p>uns liegt nun folgendes Anliegen vor:</p>\n\n<blockquote><pre>\n",
             cgi.htmltext (cgi.form.Anliegen), "\n</pre></blockquote>\n")

  -- Mehrfachauswahlen koennen nil sein, oder Strings, oder Tabellen
  if cgi.form.Art and (cgi.form.Art == "dringend" or cgi.form.Art["dringend"]) then
    cgi.write ("<p>Wir werden uns umgehend darum k&uuml;mmern.</p>\n")
  else
    cgi.write ("<p>Wir werden uns bei Gelegenheit darum k&uuml;mmern.</p>\n")
  end

  local Arbeitsplatz = cgi.var ("REMOTE_HOST") or cgi.var ("REMOTE_ADDR")
  cgi.write ("<p><small>Dieses Schreiben erreichte uns vom Arbeisplatz ",
             Arbeitsplatz, ".</small></p>\n")

  cgi.write ("<p><a href='", cgi.var ("SCRIPT_NAME"),
             "'>Weiteres Anliegen melden...</a></p>\n")

  Verarbeitung ()
  cgi.write ("\n</body>\n</html>\n")
end


local Formular = function ()
  cgi.Kopf ()

  HTML_Anfang (Titel)

  cgi.write ("<h1>", Titel, "</h1>\n\n")

  -- Dieses Skript ruft sich selbst auf.
  cgi.write ("<form method='post' action='", cgi.var ("SCRIPT_NAME") or "#", "'>\n")
  -- 'get' wuerde auch funktionieren,
  -- aber 'post' ist in den meisten Faellen besser.

  cgi.write ("Anrede:\n",
	"<label><input name='Anrede' type='radio' value='formlos' ",
	"checked='checked'/>Formlos</label>\n",
	"<label><input name='Anrede' type='radio' ",
	"value='Frau'/>Frau</label>\n",
	"<label><input name='Anrede' type='radio' ",
	"value='Herr'/>Herr</label><br/>\n")

  cgi.write ("<label>Name:\n<input type='text' ",
	 "name='Name' required='required'")

  -- Falls der Name bekannt ist, koennen wir ihn schon eintragen.
  local Name = cgi.var ("REMOTE_USER") or cgi.var ("REMOTE_IDENT")
  if Name and Name ~= "" then cgi.write (" value='", Name, "'") end

  cgi.write ("/></label><br/>\n<label>Anliegen:<br/>\n",
    "<textarea name='Anliegen' cols='50' rows='15' required='required' ",
    "wrap='hard'></textarea></label><br/>\n",
    "<label><input name='Art' type='checkbox' value='dringend'/>dringend</label> ",
    "<label><input name='Art' type='checkbox' value='Lob'/>Lob</label> ",
    "<label><input name='Art' type='checkbox' value='Kritik'/>Kritik</label> ",
    "<label><input name='Art' type='checkbox' value='Fehler'/>Fehler</label> ",
    "<label><input name='Art' type='checkbox' value='Vorschlag'/>Vorschlag</label> ",
    "<br/>\n<button>einreichen</button>\n",
    "</form>\n</body>\n</html>\n")
end


if cgi.form then Auswertung () else Formular () end
