#!/bin/sh

# Dieses Skript wurde für akfnetzserver geschrieben,
# und läuft nicht unbedingt mit anderen Servern richtig.

# Lizenz: CC0
# https://creativecommons.org/publicdomain/zero/1.0/deed.de
# SPDX-License-Identifier: CC0-1.0

if [ -n "$REMOTE_USER" ]  # Wenn der Name schon bekannt ist
then

  echo "Content-Type: text/html; charset=UTF-8"
  echo
  test "$REQUEST_METHOD" = "HEAD" && exit

  echo "<html><body style='text-align:center'>"
  echo "<h1>Hallo $REMOTE_USER!</h1>"

  # Wenn eine Anmeldung über den Server erledigt wurde,
  # ist die Variable $AUTH_TYPE gesetzt.

  echo "<p>Du bist"
  if [ -n "$AUTH_TYPE" ]
  then echo "mit der Methode $AUTH_TYPE"
  else echo "aber jetzt nicht richtig"
  fi
  echo "angemeldet.</p>"

  echo "</body></html>"

  # Für eine richtige Berechtigungsprüfung per CGI müsste man die Variable
  # $HTTP_AUTHORIZATION immer(!) mit bekannten Werten vergleichen.

else  # der Name muss noch abgefragt werden

  echo "Status: 401 Namen abfragen"
  echo "WWW-Authenticate: Basic realm=\"Bitte nur einen Namen angeben.\""
  echo "Content-Type: text/plain; charset=UTF-8"
  echo
  test "$REQUEST_METHOD" = "HEAD" && exit

  echo "Bitte nur einen Namen angeben."
  echo "Auf deutsche Umlaute sollte man verzichten (nur ASCII)."
  # Das wird angezeigt, wenn man auf Abbrechen klickt.

fi
