/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2015,2017 Andreas K. Foerster
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "akfnetz.h"

// RFC 4648

char *
akfnetz_base64_kodiert (char *Ziel, size_t Zielgroesse,
			const void *Quelle, size_t Quellgroesse,
			const char *Zeichen)
{
  const unsigned char *q = Quelle;
  char *z = Ziel;
  size_t qg = Quellgroesse, Platz = Zielgroesse;

  while (Platz >= 5 && qg)
    {
      int w1, w2, w3, w4;
      w1 = *q >> 2;
      w2 = (*q << 4) & 0x30;
      w3 = w4 = -1;

      if (--qg)
	{
	  ++q;
	  w2 |= *q >> 4;
	  w3 = (*q << 2) & 0x3C;

	  if (--qg)
	    {
	      ++q;
	      w3 |= *q >> 6;
	      w4 = *q & 0x3F;
	    }
	}

      *z++ = Zeichen[w1];
      *z++ = Zeichen[w2];
      *z++ = (w3 >= 0) ? Zeichen[w3] : '=';
      *z++ = (w4 >= 0) ? Zeichen[w4] : '=';
      Platz -= 4;

      if (!qg)
	break;

      --qg;
      ++q;
    }

  *z = '\0';

  // noch Zeichen uebrig?
  if (qg)
    {
      *Ziel = '\0';
      return NULL;
    }

  return Ziel;
}
