/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2015-2017,2020 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

// RFC 4648

#include "akfnetz.h"

static unsigned int
base64Wert (signed char z)
{
  return z >= 'a' ? z - 'a' + 26 : z == '_' ? 63 : z >= 'A' ? z - 'A'
    : z >= '0' ? z - '0' + 52 : (z == '+' || z == '-') ? 62
    : z == '/' ? 63 : 0;
}


// naechstes druckbare ASCII-Zeichen
static const signed char *
naechstes (const signed char *q)
{
  do
    ++q;
  while (*q && *q <= ' ');

  return q;
}


size_t
akfnetz_base64_Teilbereich (void *Ziel, size_t Groesse, const char *Quelle,
			    int Abbruchzeichen)
{
  size_t l;
  const signed char *q;
  char *z, abbrechen;

  l = 0;
  q = (const signed char *) Quelle;
  z = Ziel;
  abbrechen = (char) Abbruchzeichen;

  while (*q && *q <= ' ')
    q++;

  while (*q && *q != '=' && l < Groesse)
    {
      unsigned int w1, w2, w3, w4;
      char Zeichen;

      w1 = base64Wert (*q);

      q = naechstes (q);
      if (!*q)
	break;

      w2 = base64Wert (*q);

      Zeichen = (w1 << 2) | (w2 >> 4);
      if (Abbruchzeichen >= 0 && abbrechen == Zeichen)
	break;

      z[l++] = Zeichen;

      q = naechstes (q);
      if (!*q || *q == '=' || l >= Groesse)
	break;

      w3 = base64Wert (*q);
      Zeichen = ((w2 & 0x0F) << 4) | (w3 >> 2);
      if (Abbruchzeichen >= 0 && abbrechen == Zeichen)
	break;

      z[l++] = Zeichen;

      q = naechstes (q);
      if (!*q || *q == '=' || l >= Groesse)
	break;

      w4 = base64Wert (*q);
      Zeichen = ((w3 & 0x03) << 6) | w4;
      if (Abbruchzeichen >= 0 && abbrechen == Zeichen)
	break;

      z[l++] = Zeichen;
      q = naechstes (q);
    }

  // zwar wahrscheinlich Binaerdaten, aber ein abschliessendes
  // Null-Byte schadet nicht, wenn's passt
  if (l < Groesse)
    z[l] = '\0';

  return l;
}


size_t
akfnetz_base64_dekodieren (void *Ziel, size_t Groesse, const char *Quelle)
{
  return akfnetz_base64_Teilbereich (Ziel, Groesse, Quelle, -1);
}
