/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2016-2017 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdio.h>
#include <string.h>
#include "akfnetz.h"

void
akfnetz_Authorization_Basic (FILE * d, const char *Name, const char *Zugang)
{
  char kodiert[4096];

  // muessen die Daten noch kodiert werden?
  if (strchr (Zugang, ':'))
    akfnetz_base64_kodiert (kodiert, sizeof (kodiert), Zugang,
			    strlen (Zugang), AKFNETZ_BASE64);
  else if (strlen (Zugang) < sizeof (kodiert))
    strcpy (kodiert, Zugang);
  else
    return;

  fprintf (d, "%s: Basic %s\r\n", Name, kodiert);
}
