/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2016,2018,2024 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "akfnetz.h"

static int Ausgabe (const char *);

int
main (int argc, char **argv)
{
  const char *query = getenv ("QUERY_STRING");
  if (argc < 2 || !query || !*query)
    return EXIT_FAILURE;

  // Kopie von query nach q
  size_t ql = strlen (query) + 1;
  char q[ql];
  memcpy (q, query, ql);

  const char *Feld = argv[1];
  size_t l = strlen (Feld);
  int Status = EXIT_FAILURE;

  for (char *s = strtok (q, "&;"); s; s = strtok (NULL, "&;"))
    {
      akfnetz_url_dekodieren (s);
      if (!strncasecmp (s, Feld, l) && s[l] == '=' && s[l + 1])
	Status = Ausgabe (s + l + 1);
      // es koennte mehrere Werte mit dem selben Feldnamen geben
    }

  // Alternativ-Text
  if (Status != EXIT_SUCCESS && argc > 2)
    Status = Ausgabe (argv[2]);

  return Status;
}


static int
Ausgabe (const char *Wert)
{
  akfnetz_xml_Text (stdout, Wert);
  putchar ('\n');
  return EXIT_SUCCESS;
}
