/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * zeige Medientyp fuer akfnetzserver
 * Copyright (c) 2023,2025 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <locale.h>
#include "akfnetz.h"
#include "version.h"

#define VERBOTEN "[403 VERBOTEN]"

#define OPTIONEN "hVn"

static const struct option Langoption[] = {
  {"Hilfe", no_argument, NULL, 'h'},
  {"help", no_argument, NULL, 'h'},
  {"Version", no_argument, NULL, 'V'},
  {"version", no_argument, NULL, 'V'},
  {"name", no_argument, NULL, 'n'},
  {0, 0, 0, 0}
};

bool mit_Name;

static int
Hilfe (const char *n)
{
  printf ("%s [Option] [Datei] ...\n\n", n);
  puts ("Optionen:\n"
	"  -n, --name\t\tDateiname mit ausgeben\n"
	"\nHomepage: <" AKFNETZ_HOMEPAGE ">\n");

  return EXIT_SUCCESS;
}


static int
Version (void)
{
  puts ("akfnetztyp (akfnetz " AKFNETZ_VERSION ")\n\n"
	AKFNETZ_COPYRIGHT "\n"
	"Lizenz GPLv3+: GNU GPL Version 3 oder neuer "
	"<http://gnu.org/licenses/gpl.html>\n\n"
	"Dies ist freie Software. Sie darf veraendert und verteilt werden.\n"
	"Dieses Programm wird ohne Gewaehrleistung geliefert,\n"
	"soweit dies gesetzlich zulaessig ist.\n");

  return EXIT_SUCCESS;
}


static void
anzeigen (const char *Name)
{
  const char *Typ;

  Typ = akfnetz_Medientyp (Name);

  if (!*Typ)
    Typ = VERBOTEN;

  if (mit_Name)
    printf ("%s: ", Name);

  puts (Typ);
}


int
main (int argc, char *argv[])
{
  int opt;

  setlocale (LC_ALL, "");

  mit_Name = false;

  while ((opt = getopt_long (argc, argv, OPTIONEN, Langoption, NULL)) != -1)
    {
      switch (opt)
	{
	case 'h':
	  return Hilfe (argv[0]);

	case 'V':
	  return Version ();

	case 'n':
	  mit_Name = true;
	  break;

	case '?':
	  return EXIT_FAILURE;
	}
    }

  if (optind >= argc)
    Hilfe (argv[0]);
  else
    while (optind < argc)
      anzeigen (argv[optind++]);

  return EXIT_SUCCESS;
}
