/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Indexer fuer Apache
 * Copyright (c) 2015-2017,2020-2025 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
In der Apache-Konfigurationsdatei anwendbar mit:
  DirectoryIndex index.html /cgi-bin/akfindexer

Verwendet ua. die Umgebungsvariablen REQUEST_URI und DOCUMENT_ROOT,
die nicht in der CGI-Spezifikation vorkommen.
*/


#include "akfnetz.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static void Fehler (void);

int
main (void)
{
  char *Methode, *Wurzel, *URI;
  size_t wl, vl;

  Methode = getenv ("REQUEST_METHOD");
  if (!Methode)
    {
      fputs ("Fehler: In Apache mit \"DirectoryIndex\" aufrufen.\a\n",
	     stderr);
      return EXIT_FAILURE;
    }

  Wurzel = getenv ("DOCUMENT_ROOT");
  URI = getenv ("REQUEST_URI");
  if (!Wurzel || !URI)
    Fehler ();

  wl = strlen (Wurzel);
  vl = strcspn (URI, "?#");
  // Die URI kann auch den Query_String enthalten

  char Pfad[wl + vl + 1];
  memcpy (Pfad, Wurzel, wl);
  memcpy (Pfad + wl, URI, vl);
  Pfad[wl + vl] = '\0';

  // autorisierter Benutzer?
  char *Benutzer = NULL;
  char *Autorisation = getenv ("AUTH_TYPE");
  if (Autorisation && *Autorisation)
    Benutzer = getenv ("REMOTE_USER");

  fputs ("Content-Type: text/html; charset=UTF-8\r\n"
	 "Cache-Control: no-cache\r\nPragma: no-cache\r\n"
	 "Vary: Accept-Language\r\n\r\n", stdout);

  if (strcmp (Methode, "HEAD") != 0)
    akfnetz_html_Verzeichnis (stdout, Pfad, Pfad + wl, true,
			      getenv ("QUERY_STRING"),
			      getenv ("HTTP_ACCEPT_LANGUAGE"), Benutzer);

  return EXIT_SUCCESS;
}


static void
Fehler (void)
{
  fputs ("Status: 403 Forbidden\r\n"
	 "Content-Type: text/html; charset=UTF-8\r\n\r\n"
	 "<!DOCTYPE html>\r\n<html>\r\n"
	 "<body style='background-color:#FCC;text-align:center'>\r\n"
	 "<h1>Verboten</h1>\r\n</body></html>\r\n", stdout);

  exit (EXIT_FAILURE);
}
