/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2015 Andreas K. Foerster
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "akfnetz.h"
#include <time.h>

// Vergleicht Zeitangaben ohne Beruecksichtigung der Zeitzone
// Ergebnis ist kleiner 0, gleich 0, oder groesser 0
int
akfnetz_Zeitenvergleich (const struct tm *z1, const struct tm *z2)
{
  int e;

  if (!(e = z1->tm_year - z2->tm_year)
      && !(e = z1->tm_mon - z2->tm_mon)
      && !(e = z1->tm_mday - z2->tm_mday)
      && !(e = z1->tm_hour - z2->tm_hour) && !(e = z1->tm_min - z2->tm_min))
    e = z1->tm_sec - z2->tm_sec;

  return e;
}
