/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2015-2017 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "akfnetz.h"
#include <stdint.h>
#include <string.h>
#include <limits.h>


static inline char
Ziffer (uintmax_t c)
{
  return (char) ((c < 10) ? '0' + c : ('A' - 10) + c);
}


extern size_t
akfnetz_Zahlstring (char *Ergebnis, size_t Groesse,
		    uintmax_t Wert, int Basis, size_t Mindeststellen)
{
  char Puffer[sizeof (Wert) * CHAR_BIT + 1];

  *Ergebnis = '\0';
  if (Groesse < 2 || Groesse <= Mindeststellen
      || Mindeststellen >= sizeof (Puffer))
    return 0;

  // 0 wird als 10 interpretiert, um kompatibler mit strtoumax zu sein
  if (Basis == 0)
    Basis = 10;
  else if (Basis < 2 || Basis > 36)
    return 0;

  // der Puffer wird erstmal von hinten gefuellt
  char *p = &Puffer[sizeof (Puffer) - 1];

  *p = '\0';
  size_t Laenge = 1;		// beinhaltet Terminator

  do
    {
      ++Laenge;
      --p;
      *p = Ziffer (Wert % Basis);
      Wert /= Basis;
    }
  while (Wert || Laenge <= Mindeststellen);

  // passt nicht vollstaendig
  if (Laenge > Groesse)
    return 0;

  memcpy (Ergebnis, p, Laenge);

  return Laenge - 1;
}
