/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2017 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#define _POSIX_C_SOURCE 200112L

#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "akfnetz.h"


static inline char *
Textanfang (const char *s)
{
  while (*s && (*s == ' ' || *s == '\t'))
    ++s;

  return (char *) s;
}


static float
pruefe (char *Wert, char *Angebot)
{
  float q = 0.0;
  char *sp1, *sp2, *w;

  // hier wird das Attribut entfernt
  w = strtok_r (Wert, "; \t", &sp1);

  size_t l = strlen (Angebot) + 1;
  char a[l];
  memcpy (a, Angebot, l);

  for (char *t = strtok_r (a, ", \t", &sp2); t;
       t = strtok_r (NULL, ", \t", &sp2))
    {
      if (!strcasecmp (t, w))
	{
	  char *qt = strtok_r (NULL, "; \t", &sp1);

	  if (qt && !strncasecmp (qt, "q=", 2))
	    q = atof (qt + 2);
	  else
	    q = 1.0;

	  break;
	}
    }

  return q;
}


extern char *
akfnetz_Vereinbarung (const char *Akzeptanz, char *Angebot)
{
  float q = 0.0;

  if (!Angebot || !*Angebot)
    return NULL;

  char Ergebnis[strlen (Angebot) + 1];
  *Ergebnis = '\0';

  if (Akzeptanz && *Akzeptanz)
    {
      size_t l = strlen (Akzeptanz) + 1;
      char a[l];
      memcpy (a, Akzeptanz, l);

      char *sp;
      for (char *t = strtok_r (a, ",", &sp); t; t = strtok_r (NULL, ",", &sp))
	{
	  char *Wert = Textanfang (t);

	  // pruefe entfernt Attribut von Wert und gibt es als Ergebnis zurueck
	  float nq = pruefe (Wert, Angebot);
	  if (nq > q)
	    {
	      strcpy (Ergebnis, Wert);
	      q = nq;
	    }
	}
    }

  // Das Angebot wird durch das Ergebnis ersetzt, falls es eins gibt
  *Angebot = '\0';

  if (!*Ergebnis)
    return NULL;

  return strcpy (Angebot, Ergebnis);
}
