/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2018,2019,2022,2025 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <uchar.h>
#include "akfnetz.h"

#define ERSATZZEICHEN 0xFFFD

extern size_t
akfnetz_UTF8 (char *b, char32_t z)
{
  size_t l = 0;

  if (z > 0x10FFFF || (z & 0xFFFE) == 0xFFFE)
    z = ERSATZZEICHEN;

  if (z < 0x80)			// ASCII
    {
      b[0] = (char) z;
      b[1] = '\0';
      l = 1;
    }
  else if (z < 0x0800)
    {
      b[0] = (char) ((z >> 6) | 0xC0);
      b[1] = (char) ((z & 0x3F) | 0x80);
      b[2] = '\0';
      l = 2;
    }
  else if (z < 0x010000)
    {
      // UTF-16-Ersatzcode?
      if (0xD800 <= z && z <= 0xDFFF)
	z = ERSATZZEICHEN;

      b[0] = (char) ((z >> (2 * 6)) | 0xE0);
      b[1] = (char) (((z >> 6) & 0x3F) | 0x80);
      b[2] = (char) ((z & 0x3F) | 0x80);
      b[3] = '\0';
      l = 3;
    }
  else				// if (z >= 0x010000)
    {
      b[0] = (char) ((z >> (3 * 6)) | 0xF0);
      b[1] = (char) (((z >> (2 * 6)) & 0x3F) | 0x80);
      b[2] = (char) (((z >> 6) & 0x3F) | 0x80);
      b[3] = (char) ((z & 0x3F) | 0x80);
      b[4] = '\0';
      l = 4;
    }

  return l;
}
