/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2016 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "akfnetz.h"
#include <stddef.h>
#include <string.h>
#include <strings.h>


const char *
akfnetz_Tokensuche (char **Kopf, const char *Eintrag, const char *Token)
{
  const char *z = akfnetz_Kopfeintrag (Kopf, Eintrag);
  if (!z || !*z || !Token || !*Token)
    return NULL;

  size_t l = strlen (Token);

  do
    {
      if (!strncasecmp (z, Token, l))
	return z;

      // naechsten Token suchen
      z = strchr (z, ',');
      if (z)
	{
	  ++z;
	  while (*z && (*z == ' ' || *z == '\t'))
	    ++z;
	}
    }
  while (z && *z);

  return NULL;
}
