/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2016,2017 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#define _GNU_SOURCE
#define _XOPEN_SOURCE 500

#include "akfnetz.h"
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define SCHABLONE "/akfnetz-XXXXXX"

extern int
akfnetz_Temporaerdatei (const char *Verzeichnis)
{
  int t;

  if (!Verzeichnis || !*Verzeichnis)
    Verzeichnis = "/tmp";

#if defined(__linux__) && defined(O_TMPFILE)
  // namenlose Temporaerdatei, falls moeglich
  // nur fuer Linux 3.11 oder neuer
  // nur bestimmte Dateisysteme

  t = open (Verzeichnis, O_RDWR | O_TMPFILE | O_EXCL, S_IRUSR | S_IWUSR);
  if (t >= 0)
    return t;
#endif

  size_t Verzeichnislaenge = strlen (Verzeichnis);
  char Name[Verzeichnislaenge + sizeof (SCHABLONE)];

  memcpy (Name, Verzeichnis, Verzeichnislaenge);
  memcpy (Name + Verzeichnislaenge, SCHABLONE, sizeof (SCHABLONE));

  // Nur zur Sicherheit;
  // einige Varianten von mkstemp vergeben zu viele Rechte
  mode_t Maske = umask (S_IXUSR | S_IRWXG | S_IRWXO);	// 0177

  t = mkstemp (Name);
  if (t >= 0)
    unlink (Name);
  // Die Datei wird erst wirklich geloescht, wenn sie geschlossen wird.

  // alte Maske wieder herstellen
  umask (Maske);

  return t;
}
