/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright  2015,2018,2014 Andreas K. Frster
 * Etliche Formulierungen wurden von der GNU-LibC bernommen:
 * Copyright  1996, 2002 Free Software Foundation, Inc.
 * Karl Eichwalder <ke@suse.de>, 2002.
 * Jochen Hein <jochen@jochen.org>, 1996-2014.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "akfnetz.h"
#include <errno.h>

extern char *
akfnetz_Systemfehler (int Nr)
{
  char *e;

  switch (Nr)
    {
    default:
      e = "Irgend etwas ist schief gelaufen";
      break;

#ifdef EPERM
    case EPERM:
      e = "Das darfst du nicht";
      break;
#endif

#ifdef ENOENT
    case ENOENT:
      e = "Die Datei oder das Verzeichnis gibt es nicht";
      break;
#endif

#ifdef ESRCH
    case ESRCH:
      e = "Es gibt keinen solchen Prozess";
      break;
#endif

#ifdef EINTR
    case EINTR:
      e = "Der Systemaufruf wurde unterbrochen";
      break;
#endif

#ifdef EIO
    case EIO:
      e = "Ein-/Ausgabe-Fehler";
      break;
#endif

#ifdef ENXIO
    case ENXIO:
      e = "Es gibt kein solches Gert oder Adresse";
      break;
#endif

#ifdef E2BIG
    case E2BIG:
      e = "Die Argumentenliste ist zu lang";
      break;
#endif

#ifdef ENOEXEC
    case ENOEXEC:
      e = "Fehler im Format der ausfhrbaren Datei";
      break;
#endif

#ifdef EBADF
    case EBADF:
      e = "Falsche Dateinummer";
      break;
#endif

#ifdef ECHILD
    case ECHILD:
      e = "Es gibt keinen Kindprozess";
      break;
#endif

#ifdef EAGAIN
    case EAGAIN:
      e = "Noch einmal versuchen";
      break;
#endif

#ifdef ENOMEM
    case ENOMEM:
      e = "Der Speicher ist voll";
      break;
#endif

#ifdef EACCES
    case EACCES:
      e = "Der Zugriff wurde verweigert";
      break;
#endif

#ifdef EFAULT
    case EFAULT:
      e = "Die Adresse ist fehlerhaft";
      break;
#endif

#ifdef ENOTBLK
    case ENOTBLK:
      e = "Es wird ein Blockgert erwartet";
      break;
#endif

#ifdef EBUSY
    case EBUSY:
      e = "Das Gert oder die Ressource ist beschftigt";
      break;
#endif

#ifdef EEXIST
    case EEXIST:
      e = "Die Datei existiert bereits";
      break;
#endif

#ifdef EXDEV
    case EXDEV:
      e = "Verknpfung ber verschiedene Gerte hinweg";
      break;
#endif

#ifdef ENODEV
    case ENODEV:
      e = "Es gibt kein solches Gert";
      break;
#endif

#ifdef ENOTDIR
    case ENOTDIR:
      e = "Das ist kein Verzeichnis";
      break;
#endif

#ifdef EISDIR
    case EISDIR:
      e = "Das ist ein Verzeichnis";
      break;
#endif

#ifdef EINVAL
    case EINVAL:
      e = "Das Argument ist ungltig";
      break;
#endif

#ifdef ENFILE
    case ENFILE:
      e = "Es sind insgesamt zu viele Dateien auf dem System geffnet";
      break;
#endif

#ifdef EMFILE
    case EMFILE:
      e = "Es sind zu viele Dateien geffnet";
      break;
#endif

#ifdef ENOTTY
    case ENOTTY:
      e = "Fehlerhafter IOCTL fr das Gert";
      break;
#endif

#ifdef ETXTBSY
    case ETXTBSY:
      e = "Das Programm kann nicht ausgefhrt oder verndert werden";
      break;
#endif

#ifdef EFBIG
    case EFBIG:
      e = "Die Datei ist zu gro";
      break;
#endif

#ifdef ENOSPC
    case ENOSPC:
      e = "Der Datentrger ist voll";
      break;
#endif

#ifdef ESPIPE
    case ESPIPE:
      e = "Es ist keine Positionsnderung mglich";
      break;
#endif

#ifdef EROFS
    case EROFS:
      e = "Dieses Dateisystem kann nur gelesen werden";
      break;
#endif

#ifdef EMLINK
    case EMLINK:
      e = "Zu viele Verknpfungen";
      break;
#endif

#ifdef EPIPE
    case EPIPE:
      e = "Die Kommunikation (Pipe) ist unterbrochen worden";
      break;
#endif

#ifdef EDOM
    case EDOM:
      e = "Das nummerische Argument ist auerhalb des Gltigkeitsbereiches";
      break;
#endif

#ifdef ERANGE
    case ERANGE:
      e = "Das Ergebnis ist nicht darstellbar";
      break;
#endif

#if defined(EDEADLOCK) && EDEADLOCK != EDEADLK
    case EDEADLOCK:
      e = "Ein Datenstau wurde vermieden";
      break;
#endif

#ifdef EDEADLK
    case EDEADLK:
      e = "Ein Datenstau wurde vermieden";
      break;
#endif

#ifdef ENAMETOOLONG
    case ENAMETOOLONG:
      e = "Der Dateiname ist zu lang";
      break;
#endif

#ifdef ENOLCK
    case ENOLCK:
      e = "Es sind keine Sperrungen verfgbar";
      break;
#endif

#ifdef ENOSYS
    case ENOSYS:
      e = "Die Funktion ist nicht eingebaut";
      break;
#endif

#ifdef ENOTEMPTY
    case ENOTEMPTY:
      e = "Das Verzeichnis ist nicht leer";
      break;
#endif

#ifdef ELOOP
    case ELOOP:
      e = "Es gibt eine Endlosschleife durch symbolische Verknpfungen";
      break;
#endif

#if defined(EWOULDBLOCK) && EWOULDBLOCK != EAGAIN
    case EWOULDBLOCK:
      e = "Die Operation wrde blockieren";
      break;
#endif

#ifdef ENOMSG
    case ENOMSG:
      e = "Das ist keine Nachricht des gewnschten Typs";
      break;
#endif

#ifdef EIDRM
    case EIDRM:
      e = "Der Bezeichner wurde entfernt";
      break;
#endif

#ifdef ECHRNG
    case ECHRNG:
      e = "Die Kanalnummer ist auerhalb des Gltigkeitsbereiches";
      break;
#endif

#ifdef EL2NSYNC
    case EL2NSYNC:
      e = "Level 2 nicht synchronisiert";
      break;
#endif

#ifdef EL3HLT
    case EL3HLT:
      e = "Level 3 angehalten";
      break;
#endif

#ifdef EL3RST
    case EL3RST:
      e = "Level 3 zurckgesetzt";
      break;
#endif

#ifdef ELNRNG
    case ELNRNG:
      e = "Die Linknummer ist auerhalb des Gltigkeitsbereiches";
      break;
#endif

#ifdef EUNATCH
    case EUNATCH:
      e = "Das Protokoll ist nicht verfgbar";
      break;
#endif

#ifdef ENOCSI
    case ENOCSI:
      e = "Keine CSI-Struktur verfgbar";
      break;
#endif

#ifdef EL2HLT
    case EL2HLT:
      e = "Level 2 angehalten";
      break;
#endif

#ifdef EBADE
    case EBADE:
      e = "Der Austausch ist ungltig";
      break;
#endif

#ifdef EBADR
    case EBADR:
      e = "Der Anfragebezeichner ist ungltig";
      break;
#endif

#ifdef EXFULL
    case EXFULL:
      e = "Der Austausch ist berfllt";
      break;
#endif

#ifdef ENOANO
    case ENOANO:
      e = "Keine Anode";
      break;
#endif

#ifdef EBADRQC
    case EBADRQC:
      e = "Ungltiger Aufruf-Code";
      break;
#endif

#ifdef EBADSLT
    case EBADSLT:
      e = "Ungltiger Slot";
      break;
#endif

#ifdef EBFONT
    case EBFONT:
      e = "Fehlerhaftes Dateiformat bei Schriftendatei";
      break;
#endif

#ifdef ENOSTR
    case ENOSTR:
      e = "Das ist kein Datenstrom";
      break;
#endif

#ifdef ENODATA
    case ENODATA:
      e = "Es sind keine Daten verfgbar";
      break;
#endif

#ifdef ETIME
    case ETIME:
      e = "Die Zeit ist abgelaufen";
      break;
#endif

#ifdef ENOSR
    case ENOSR:
      e = "Es sind keine Datenstrom-Ressourcen mehr verfgbar";
      break;
#endif

#ifdef ENONET
    case ENONET:
      e = "Das Gert ist nicht im Netzwerk";
      break;
#endif

#ifdef ENOPKG
    case ENOPKG:
      e = "Das Paket ist nicht installiert";
      break;
#endif

#ifdef EREMOTE
    case EREMOTE:
      e = "Das Objekt ist extern";
      break;
#endif

#ifdef ENOLINK
    case ENOLINK:
      e = "Der Link wurde beschdigt";
      break;
#endif

#ifdef EADV
    case EADV:
      e = "Konflikt in Bekanntmachung";
      break;
#endif

#ifdef ESRMNT
    case ESRMNT:
      e = "Srmount-Fehler";
      break;
#endif

#ifdef ECOMM
    case ECOMM:
      e = "Kommunikationsfehler beim Senden";
      break;
#endif

#ifdef EPROTO
    case EPROTO:
      e = "Protokollfehler";
      break;
#endif

#ifdef EMULTIHOP
    case EMULTIHOP:
      e = "Ein Multihop wurde versucht";
      break;
#endif

#ifdef EDOTDOT
    case EDOTDOT:
      e = "RFS-spezifischer Fehler";
      break;
#endif

#ifdef EBADMSG
    case EBADMSG:
      e = "Die Nachricht war fehlerhaft";
      break;
#endif

#ifdef EOVERFLOW
    case EOVERFLOW:
      e = "Der Wert ist zu gro fr den definierten Datentyp";
      break;
#endif

#ifdef ENOTUNIQ
    case ENOTUNIQ:
      e = "Der Name ist im Netzwerk nicht eindeutig";
      break;
#endif

#ifdef EBADFD
    case EBADFD:
      e = "Die Dateizugriffsnummer ist in schlechter Verfassung";
      break;
#endif

#ifdef EREMCHG
    case EREMCHG:
      e = "Die Adresse der Gegenstelle hat sich gendert";
      break;
#endif

#ifdef ELIBACC
    case ELIBACC:
      e = "Auf eine bentigte Bibliothek konnte nicht zugegriffen werden";
      break;
#endif

#ifdef ELIBSCN
    case ELIBSCN:		// .lib section in a.out corrupted
      e = "Die Bibliothek ist kaputt";
      break;
#endif

#ifdef ELIBBAD
    case ELIBBAD:
      e = "Die Bibliothek ist kaputt";
      break;
#endif

#ifdef ELIBMAX
    case ELIBMAX:
      e = "Es wurde versucht zu viele Bibliotheken einzubinden";
      break;
#endif

#ifdef ELIBEXEC
    case ELIBEXEC:
      e = "Eine Bibliothek kann nicht direkt aufgerufen werden";
      break;
#endif

#ifdef EILSEQ
    case EILSEQ:
      e = "Fehlerhafte Byte-Sequenz";
      break;
#endif

#ifdef ERESTART
    case ERESTART:
      e = "Der unterbrochene Systemaufruf sollte neu gestartet werden";
      break;
#endif

#ifdef ESTRPIPE
    case ESTRPIPE:
      e = "Fehler beim Datenstrom-Filter";
      break;
#endif

#ifdef EUSERS
    case EUSERS:
      e = "Zu viele Benutzer";
      break;
#endif

#ifdef ENOTSOCK
    case ENOTSOCK:
      e = "Socket-Operation auf etwas, das kein Socket ist";
      break;
#endif

#ifdef EDESTADDRREQ
    case EDESTADDRREQ:
      e = "Zieladresse bentigt";
      break;
#endif

#ifdef EMSGSIZE
    case EMSGSIZE:
      e = "Die Nachricht ist zu lang";
      break;
#endif

#ifdef EPROTOTYPE
    case EPROTOTYPE:
      e = "Das Protokoll passt nicht zum Socket";
      break;
#endif

#ifdef ENOPROTOOPT
    case ENOPROTOOPT:
      e = "Das Protokoll ist nicht verfgbar";
      break;
#endif

#ifdef EPROTONOSUPPORT
    case EPROTONOSUPPORT:
      e = "Das Protokoll wird nicht untersttzt";
      break;
#endif

#ifdef ESOCKTNOSUPPORT
    case ESOCKTNOSUPPORT:
      e = "Der Sockettyp wird nicht untersttzt";
      break;
#endif

#if defined(EOPNOTSUPP) && EOPNOTSUPP != ENOTSUP
    case EOPNOTSUPP:
      e = "Die Operation wird nicht untersttzt";
      break;
#endif

#ifdef ENOTSUP
    case ENOTSUP:
      e = "Die Operation wird nicht untersttzt";
      break;
#endif

#ifdef EPFNOSUPPORT
    case EPFNOSUPPORT:
      e = "Die Protokollfamilie wird nicht untersttzt";
      break;
#endif

#ifdef EAFNOSUPPORT
    case EAFNOSUPPORT:
      e = "Die Adressenfamilie wird von dem Protokoll nicht untersttzt";
      break;
#endif

#ifdef EADDRINUSE
    case EADDRINUSE:
      e = "Die Adresse wird bereits verwendet";
      break;
#endif

#ifdef EADDRNOTAVAIL
    case EADDRNOTAVAIL:
      e = "Die angeforderte Adresse kann nicht zugewiesen werden";
      break;
#endif

#ifdef ENETDOWN
    case ENETDOWN:
      e = "Das Netzwerk ist nicht aktiv";
      break;
#endif

#ifdef ENETUNREACH
    case ENETUNREACH:
      e = "Das Netzwerk ist nicht erreichbar";
      break;
#endif

#ifdef ENETRESET
    case ENETRESET:
      e = "Das Netzwerk hat die Verbindung nach einem Reset verloren";
      break;
#endif

#ifdef ECONNABORTED
    case ECONNABORTED:
      e = "Das Programm verursachte den Abbruch der Verbindung";
      break;
#endif

#ifdef ECONNRESET
    case ECONNRESET:
      e = "Die Verbindung wurde vom Kommunikationspartner zurckgesetzt";
      break;
#endif

#ifdef ENOBUFS
    case ENOBUFS:
      e = "Kein Platz mehr im Puffer";
      break;
#endif

#ifdef EISCONN
    case EISCONN:
      e = "Der Transportendpunkt ist bereits verbunden";
      break;
#endif

#ifdef ENOTCONN
    case ENOTCONN:
      e = "Der Transportendpunkt ist nicht verbunden";
      break;
#endif

#ifdef ESHUTDOWN
    case ESHUTDOWN:
      e =
	"Man kann nicht senden, nachdem der Transportendpunkt beendet wurde";
      break;
#endif

#ifdef ETOOMANYREFS
    case ETOOMANYREFS:
      e = "Es gibt zu viele Referenzen: Ich kann nicht verbinden";
      break;
#endif

#ifdef ETIMEDOUT
    case ETIMEDOUT:
      e = "Die Verbindung brauchte zu lange";
      break;
#endif

#ifdef ECONNREFUSED
    case ECONNREFUSED:
      e = "Die Verbindung wurde verweigert";
      break;
#endif

#ifdef EHOSTDOWN
    case EHOSTDOWN:
      e = "Der Zielrechner ist nicht aktiv";
      break;
#endif

#ifdef EHOSTUNREACH
    case EHOSTUNREACH:
      e = "Keine Route zum Zielrechner";
      break;
#endif

#ifdef EALREADY
    case EALREADY:
      e = "Die Operation wird bereits ausgefhrt";
      break;
#endif

#ifdef EINPROGRESS
    case EINPROGRESS:
      e = "Die Operation wird jetzt ausgefhrt";
      break;
#endif

#ifdef ESTALE
    case ESTALE:
      e = "Veraltete NFS-Dateizugriffsnummer";
      break;
#endif

#ifdef EUCLEAN
    case EUCLEAN:
      e = "Die Struktur muss bereinigt werden";
      break;
#endif

#ifdef ENOTNAM
    case ENOTNAM:
      e = "Keine XENIX named type-Datei";
      break;
#endif

#ifdef ENAVAIL
    case ENAVAIL:
      e = "Keine XENIX-Semaphoren verfgbar";
      break;
#endif

#ifdef EISNAM
    case EISNAM:
      e = "Das ist eine named type-Datei";
      break;
#endif

#ifdef EREMOTEIO
    case EREMOTEIO:
      e = "Ein-/Ausgabefehler beim Netzwerkpartner";
      break;
#endif

#ifdef EDQUOT
    case EDQUOT:
      e = "Die Quota wurde berschritten";
      break;
#endif

#ifdef ENOMEDIUM
    case ENOMEDIUM:
      e = "Es wurde kein Medium gefunden";
      break;
#endif

#ifdef EMEDIUMTYPE
    case EMEDIUMTYPE:
      e = "Das ist der falsche Medientyp";
      break;
#endif

#ifdef ECANCELED
    case ECANCELED:
      e = "Die Operation wurde abgebrochen";
      break;
#endif

#ifdef ENOKEY
    case ENOKEY:
      e = "Der erforderliche Schlssel ist nicht verfgbar";
      break;
#endif

#ifdef EKEYEXPIRED
    case EKEYEXPIRED:
      e = "Der Schlssel ist veraltet";
      break;
#endif

#ifdef EKEYREVOKED
    case EKEYREVOKED:
      e = "Dieser Schlssel wurde fr ungltig erklrt";
      break;
#endif

#ifdef EKEYREJECTED
    case EKEYREJECTED:
      e = "Der Schlssel wurde abgelehnt";
      break;
#endif

/*  Mutex */
#ifdef EOWNERDEAD
    case EOWNERDEAD:
      e = "Der Eigentmer-Prozess wurde beendet";
      break;
#endif

#ifdef ENOTRECOVERABLE
    case ENOTRECOVERABLE:
      e = "Der Status ist nicht wiederherstellbar";
      break;
#endif

#ifdef ERFKILL
    case ERFKILL:
      e = "Die Operation ist nicht mglich wegen RF-kill";
      break;
#endif

#ifdef EHWPOISON
    case EHWPOISON:
      e = "Eine Speicher-Seite hat einen Hardware-Fehler";
      break;
#endif
    }

  return e;
}
