/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2015-2017 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "akfnetz.h"

char *
akfnetz_Statusmeldung (int Status)
{
  char *e = "";

  switch (Status / 100)
    {
      // Zwischenmeldungen:
    case 1:
      switch (Status)
	{
	default:
	case 100:
	  e = "weitermachen";
	  break;

	case 101:
	  e = "Protokollwechsel";
	  break;

	case 102:
	  e = "bitte warten...";
	  break;
	}
      break;


      // Erfolgsmeldungen:
    case 2:
      switch (Status)
	{
	default:
	case 200:
	  e = "Okay";
	  break;

	case 201:
	  e = "erstellt";
	  break;

	case 202:
	  e = "akzeptiert";
	  break;

	case 203:
	  e = "veraenderte Antwort";
	  break;

	case 204:		// Erfolgsmeldung ohne Inhalt
	  e = "erledigt";
	  break;

	case 205:
	  e = "Formular loeschen";
	  break;

	case 206:
	  e = "Teilstueck wird uebertragen";
	  break;

	case 207:
	  e = "Multi-Status";
	  break;

	case 208:
	  e = "bereits ausgefuehrt";
	  break;
	}
      break;


      // Umleitungen:
    case 3:
      switch (Status)
	{
	default:
	case 300:
	  e = "mehrere Auswahlmoeglichkeiten";
	  break;

	case 301:
	  e = "dauerhaft verschoben";
	  break;

	case 302:
	  e = "gefunden";
	  break;

	case 303:
	  e = "siehe dort";
	  break;

	case 304:
	  e = "unveraendert";
	  break;

	case 305:
	  e = "Proxy benutzen";
	  break;

	case 306:		// aus Standard entfernt
	  e = "Proxy wechseln";
	  break;

	case 307:
	  e = "vorlaeufig verschoben";
	  break;

	case 308:
	  e = "dauerhaft verschoben";
	  break;
	}
      break;


      // Client-Fehler:
    case 4:
      switch (Status)
	{
	default:
	case 400:
	  e = "fehlerhafte Anfrage";
	  break;

	case 401:
	  e = "richtige Zugangsdaten benoetigt";
	  break;

	case 402:
	  e = "Bezahlung verlangt";
	  break;

	case 403:
	  e = "Verboten";
	  break;

	case 404:
	  e = "nicht gefunden";
	  break;

	case 405:
	  e = "Anfragemethode nicht erlaubt";
	  break;

	case 406:
	  e = "inakzeptabel";
	  break;

	case 407:
	  e = "richtige Zugangsdaten fuer Proxy benoetigt";
	  break;

	case 408:
	  e = "Zeit fuer Anfrage abgelaufen";
	  break;

	case 409:
	  e = "Konflikt";
	  break;

	case 410:
	  e = "steht nicht mehr zur Verfuegung";
	  break;

	case 411:
	  e = "Laengenangabe benoetigt";
	  break;

	case 412:
	  e = "Voraussetzung nicht erfuellt";
	  break;

	case 413:
	  e = "Anfrage-Inhalt zu lang";
	  break;

	case 414:
	  e = "Anfrage-URL zu lang";
	  break;

	case 415:
	  e = "nicht unterstuetzter Medientyp";
	  break;

	case 416:
	  e = "angeforderter Bereich nicht erfuellbar";
	  break;

	case 417:
	  e = "Erwartung nicht erfuellt";
	  break;

	case 418:		// RFC 2324
	  e = "Ich bin eine Teekanne";
	  break;

	case 420:
	  e = "Bedingung nicht erfuellt";
	  break;

	case 421:
	  e = "fehlgeleitete Anfrage";
	  break;

	case 422:
	  e = "Anfrage nicht zu bearbeiten";
	  break;

	case 423:
	  e = "gesperrt";
	  break;

	case 424:
	  e = "Voraussetzung nicht erfuellt";
	  break;

	case 426:
	  e = "Upgrade erforderlich";
	  break;

	case 428:
	  e = "Voraussetzung nicht erfuellt";
	  break;

	case 429:
	  e = "zu viele Anfragen";
	  break;

	case 431:
	  e = "Anfrage-Kopf zu lang";
	  break;

	case 451:
	  e = "aus rechtlichen Gruenden zensiert";
	  break;
	}
      break;


      // Server-Fehler:
    case 5:
      switch (Status)
	{
	default:
	case 500:
	  e = "interner Serverfehler";
	  break;

	case 501:
	  e = "nicht eingebaut";
	  break;

	case 502:
	  e = "fehlerhaftes Gateway";
	  break;

	case 503:
	  e = "Service nicht verfuegbar";
	  break;

	case 504:
	  e = "Gateway-Zeitueberschreitung";
	  break;

	case 505:
	  e = "HTTP-Version nicht unterstuetzt";
	  break;

	case 506:
	  e = "Zirkelbezug";
	  break;

	case 507:
	  e = "der Speicher auf dem Server ist voll";
	  break;

	case 508:
	  e = "Schleife entdeckt";
	  break;

	case 509:
	  e = "Bandbreite ueberschritten";
	  break;

	case 510:
	  e = "Erweiterungsfehler";
	  break;

	case 511:
	  e = "richtige Zugangsdaten fuer das Netzwerk benoetigt";
	  break;
	}
      break;


      // interne Fehler (kein Standard)
    case 9:
      switch (Status)
	{
	default:
	case 900:
	  e = "interner Software-Fehler";
	  break;

	case 901:
	  e = "Verbindung zum Server fehlgeschlagen";
	  break;

	case 902:
	  e = "Server-Antwort nicht verstanden";
	  break;
	}
      break;
    }

  return e;
}
