/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2017,2023-2024 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#define _POSIX_C_SOURCE 200112L

#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "akfnetz.h"

static int pruefe (const char *, const char *);
static double Qualitaetspruefung (const char *);
static inline char *Textanfang (const char *);

#pragma GCC poison  strtok

extern int
akfnetz_Sprachauswahl (const char *Akzeptanz, const char *unterstuetzt)
{
  int Ergebnis = -1;
  double q = 0.0;
  char *sp;

  if (!unterstuetzt || !*unterstuetzt || !Akzeptanz || !*Akzeptanz)
    return Ergebnis;

  size_t l = strlen (Akzeptanz) + 1;
  char a[l];
  memcpy (a, Akzeptanz, l);

  for (char *t = strtok_r (a, ",", &sp); t; t = strtok_r (NULL, ",", &sp))
    {
      double nq = Qualitaetspruefung (t);

      // von geringerer Qualitaet?
      if (nq <= q)
	continue;

      int nr = pruefe (Textanfang (t), unterstuetzt);

      if (nr >= 0)
	{
	  q = nq;
	  Ergebnis = nr;
	}
    }

  return Ergebnis;
}


static int
pruefe (const char *Token, const char *unterstuetzt)
{
  int nr;
  char *sp;

  size_t l = strlen (unterstuetzt) + 1;
  char a[l];
  memcpy (a, unterstuetzt, l);

  nr = 0;
  for (char *t = strtok_r (a, ",", &sp); t; t = strtok_r (NULL, ",", &sp))
    {
      // Stimmen die ersten zwei Zeichen ueberein?
      if (!strncasecmp (Textanfang (t), Token, 2))
	return nr;

      ++nr;
    }

  return -1;
}


// prueft die Qualitaetsangabe; Standardwert = 1.0
static double
Qualitaetspruefung (const char *s)
{
  char *qt;
  double q;

  q = 1.0;
  qt = strchr (s, ';');

  if (qt)
    {
      qt = Textanfang (qt + 1);
      if (!strncasecmp (qt, "q=", 2))
	q = strtod (qt + 2, NULL);
    }

  return q;
}



static inline char *
Textanfang (const char *s)
{
  while (*s && (*s == ' ' || *s == '\t'))
    ++s;

  return ((char *) s);
}
