/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2015-2017,2023 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

// nur fuer make check

// verwendet statische Definitionen aus dieser Datei
#include "Medientyp.c"

#include "akfnetz.h"
#include <ctype.h>
#include <stdlib.h>
#include <stdbool.h>

extern int akfnetz_Medientypfehler (char *, size_t);

static bool
Grossbuchstaben (const char *s)
{
  for (int i = 0; *s && i < MAX_ENDUNG; ++i, ++s)
    if (isupper (*s))
      return true;

  return false;
}


extern int
akfnetz_Medientypfehler (char *p, size_t l)
{
  if (p && l)
    *p = '\0';

  for (size_t i = 1; i < Anzahl; ++i)
    if (!Medientypen[i].Typ
	|| Grossbuchstaben (Medientypen[i].Endung)
	|| Vergleich (&Medientypen[i - 1], &Medientypen[i]) >= 0)
      {
	if (p && l > MAX_ENDUNG)
	  {
	    memcpy (p, Medientypen[i].Endung, MAX_ENDUNG);
	    p[MAX_ENDUNG] = '\0';
	  }

	return -1;
      }

  return Anzahl;
}
