/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2018 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef _WIN32

#include "akfnetz.h"
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <errno.h>

extern int
akfnetz_Lokalverbindung (const char *Pfad)
{
  int sock;
  size_t l;
  struct sockaddr_un Adresse = {.sun_family = AF_UNIX };

  l = strlen (Pfad);
  if (l >= sizeof (Adresse.sun_path))
    {
      errno = ENAMETOOLONG;
      return -1;
    }

  sock = socket (PF_UNIX, SOCK_STREAM, 0);
  if (sock < 0)
    return -1;

  memcpy (Adresse.sun_path, Pfad, l + 1);

  if (connect (sock, (struct sockaddr *) &Adresse, sizeof (Adresse)) < 0)
    {
      int e = errno;
      close (sock);
      errno = e;
      return -1;
    }

  return sock;
}

#endif
