/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2018-2024 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#define _POSIX_C_SOURCE 200112L
#define _XOPEN_SOURCE 600

#include <stdio.h>
#include <time.h>
#include <string.h>
#include "akfnetz.h"
#include "akfwebserver.h"


static inline const char *
Eintrag (const char *e)
{
  return ((e && *e) ? e : "-");
}


// Gibt Namen, Adresse oder "-" aus
static inline char *
Klientenname (void)
{
  char *Klient;

  if (Einstellung.Datenschutz)
    Klient = "-";
  else if (http.Klientenname)
    Klient = http.Klientenname;
  else if (*http.Klientenadresse)
    Klient = http.Klientenadresse;
  else
    Klient = "-";

  return Klient;
}


static char *
Logbuch_Name (void)
{
  if (Einstellung.Datenschutz)
    return http.autorisiert ? "login" : "-";

  // der Name wird auch ausgegeben, wenn er nicht autorisiert ist
  return *http.Name ? http.Name : "-";
}


extern void
Logbuch_Verbindung (void)
{
  char Zeit[81];
  time_t jetzt;
  struct tm z;

  time (&jetzt);
  strftime (Zeit, sizeof (Zeit), "%A, %F, %T", localtime_r (&jetzt, &z));

  akfnetz_Logbuch ("@ %s, %s\n", Zeit, Klientenname ());
}


extern void
Logbucheintrag (void)
{
  struct tm z;
  char Zeit[29], Laenge[40];

  if (Einstellung.virtuell)
    akfnetz_Logbuch ("%s ",
		     http.Virtuellname ? http.Virtuellname
		     : http.Host ? http.Host : "-");

  if (http.Zeitpunkt != (time_t) (-1))
    strftime (Zeit, sizeof (Zeit), "[%d/%b/%Y:%H:%M:%S %z]",
	      localtime_r (&http.Zeitpunkt, &z));
  else
    strcpy (Zeit, "-");

  if (http.Status == 204 || http.Status == 205 || http.Status == 304
      || http.Status < 200 || http.Methode == HEAD)
    memcpy (Laenge, "-", 2);
  else
    snprintf (Laenge, sizeof (Laenge), "%ju", http.Antwortlaenge);

  // "Combined Log Format"
  // Das zweite Feld ist fuer ident reserviert
  akfnetz_Logbuch ("%s - %s %s \"%s\" %03hu %s \"%s\" \"%s\"\n",
		   Klientenname (), Logbuch_Name (), Zeit,
		   Eintrag (http.Anfragezeile), http.Status, Laenge,
		   Eintrag (akfnetz_Kopfeintrag (http.Kopf, "Referer")),
		   Eintrag (akfnetz_Kopfeintrag (http.Kopf, "User-Agent")));
}
