/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2020 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#define _POSIX_C_SOURCE 200112L
#define _XOPEN_SOURCE 600

#include <stdlib.h>
#include <string.h>
#include "akfnetz.h"

// fuegt Kopie von Wert am Anfang der Liste hinzu
extern int
akfnetz_Listeneintrag (struct akfnetz_Liste **Liste,
		       const char *Wert, size_t Laenge)
{
  struct akfnetz_Liste *neu;
  char *Eintrag;

  if (!Liste || !Wert)
    return 0;

  if (!Laenge)
    Laenge = strlen (Wert);

  Eintrag = malloc (Laenge + 1);
  if (!Eintrag)
    return -1;

  neu = malloc (sizeof (*neu));
  if (!neu)
    {
      free (Eintrag);
      return -1;
    }

  neu->Eintrag = memcpy (Eintrag, Wert, Laenge + 1);
  neu->Laenge = Laenge;
  neu->weiter = *Liste;
  *Liste = neu;

  return 0;
}


extern void
akfnetz_Listenfreigabe (struct akfnetz_Liste **Liste)
{
  struct akfnetz_Liste *l, *w;

  if (!Liste)
    return;

  l = *Liste;
  while (l)
    {
      w = l->weiter;
      free ((void *) l->Eintrag);
      free (l);
      l = w;
    }

  *Liste = NULL;
}
