/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2018,2023-2025 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "akfnetz.h"

#define VERWEIS "&#x2192;"

extern void
akfnetz_html_Linkseite (FILE * d, const char *URL)
{
  fputs ("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\r\n\r\n"
	 "<html>\r\n<head>\r\n<title>", d);

  akfnetz_xml_Text (d, URL);
  fputs ("</title>\r\n</head><body>\r\n<p>" VERWEIS "<a\r\nhref='", d);
  akfnetz_xml_Text (d, URL);
  fputs ("'\r\n>", d);
  akfnetz_xml_Text (d, URL);
  fputs ("</a></p>\r\n</body></html>\r\n", d);
}
