/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2016 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "akfnetz.h"
#include <ctype.h>
#include <string.h>
#include <strings.h>


static const char *
unleer (const char *p)
{
  while (*p && isspace (*p))
    ++p;

  return p;
}


void
akfnetz_Links (const char *HTML,
	       void (*Verarbeitung) (const char *, size_t, void *), void *d)
{
  const char *p;
  p = HTML;

  // erstmal <body> suchen
  do
    {
      p = strchr (p, '<');
      if (p)
	++p;
    }
  while (p && *p && strncasecmp ("body", p, 4) != 0);

  // der HTML-Standard erlaubt das <body>-Tag wegzulassen :-(
  if (!p || !*p)
    p = HTML;

  // naechstes Tag nach <body>
  p = strchr (p, '<');
  if (!p)
    return;

  // in Tag-Inhalt nach href suchen
  for (; *p; ++p)
    {
      if (*p == '>')
	{
	  // naechtes Tag
	  p = strchr (p, '<');
	  if (!p)
	    break;		// wahrscheinlichster Endpunkt der Schleife
	}
      else if ((*p == 'h' || *p == 'H') && !strncasecmp ("href", p, 4))
	{
	  p = unleer (p + 4);

	  // es koennte auch hreflang sein
	  if (*p != '=')
	    continue;

	  p = unleer (p + 1);

	  size_t Laenge;
	  if (*p == '"' || *p == '\'')
	    {
	      char Anf = *p++;
	      Laenge = (size_t) (strchr (p, Anf) - p);
	    }
	  else			// Attribut ohne Anfuehrungsstriche :-(
	    Laenge = strcspn (p, "\"'' \t\r\n\f\v<>");

	  Verarbeitung (p, Laenge, d);
	}
    }
}
