/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2015-2017 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "akfnetz.h"
#include <stdint.h>
#include <inttypes.h>

static inline uintmax_t
absolut (intmax_t x)
{
  if (x == INTMAX_MIN)
    return (uintmax_t) x;	// kein undefiniertes Verhalten
  else
    return (uintmax_t) imaxabs (x);
}


extern size_t
akfnetz_Ganzzahlstring (char *Puffer, size_t Groesse,
			intmax_t Wert, int Basis, size_t Mindeststellen)
{
  size_t l;

  if (Wert < 0 && Puffer && Groesse > 1)
    {
      *Puffer = '-';

      if (Mindeststellen > 0)
	--Mindeststellen;

      l = akfnetz_Zahlstring (Puffer + 1, Groesse - 1,
			      absolut (Wert), Basis, Mindeststellen);


      if (l != 0)
	++l;
      else
	*Puffer = '\0';
    }
  else
    l = akfnetz_Zahlstring (Puffer, Groesse, (uintmax_t) Wert,
			    Basis, Mindeststellen);

  return l;
}
