/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2015,2018 Andreas K. Foerster
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "akfnetz.h"
#include <stdint.h>
#include <inttypes.h>


static inline uintmax_t
absolut (intmax_t x)
{
  if (x == INTMAX_MIN)
    return (uintmax_t) x;	// kein undefiniertes Verhalten
  else
    return (uintmax_t) imaxabs (x);
}


extern void
akfnetz_Ganzzahl (int fd, intmax_t Wert, int Basis, size_t Mindeststellen)
{
  if (Wert < 0)
    {
      akfnetz_Ausgabe (fd, "-", 1);

      if (Mindeststellen > 0)
	--Mindeststellen;
    }

  akfnetz_Zahl (fd, absolut (Wert), Basis, Mindeststellen);
}
