/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2018 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <unistd.h>
#include <string.h>
#include <errno.h>
#include "akfnetz.h"

extern int
akfnetz_Eingabe (int fd, void *Puffer, size_t Laenge)
{
  ssize_t r;
  size_t Rest;
  char *s;

  s = Puffer;
  Rest = Laenge;

  do
    {
      r = read (fd, s, Rest);

      if (!r)
	{
	  errno = ECONNRESET;
	  return -1;
	}

      if (r > 0)
	{
	  s += r;
	  Rest -= r;
	}
    }
  while ((r < 0 && errno == EINTR) || Rest);

  return 0;
}
