/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2015-2017 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdio.h>
#include <time.h>
#include <limits.h>
#include "akfnetz.h"


long unsigned int
akfnetz_Dauer (FILE * aus, time_t Startzeit, bool deutsch)
{
  time_t jetzt;

  time (&jetzt);

  // Hat der ueberhaupt eine Uhr?
  if (jetzt == (time_t) (-1) || Startzeit == (time_t) (-1) || Startzeit < 0)
    return 0;

  register time_t Unterschied = jetzt - Startzeit;
  if (0 >= Unterschied || Unterschied > ULONG_MAX)
    return 0;

  // Ganzzahl, um besser vergleichen zu koennen
  // (time_t koennte auch eine Fliesskommazahl sein)
  long unsigned int Zeit = (long unsigned int) Unterschied;
  // bei 32-Bit reicht das etwa fuer 136 Jahre

  fputs (deutsch ? "benoetigte Zeit: " : "elapsed time: ", aus);

  if (Zeit >= (24LU * 60LU * 60LU))
    fprintf (aus, deutsch ? "%lu Tage, " : "%lu days, ",
	     Zeit / (24LU * 60LU * 60LU));

  if (Zeit >= (60LU * 60LU))
    fprintf (aus, deutsch ? "%lu Stunden, " : "%lu hours, ",
	     Zeit / (60LU * 60LU) % 24LU);

  if (Zeit >= 60LU)
    fprintf (aus, deutsch ? "%lu Minuten und " : "%lu minutes and ",
	     (Zeit / 60LU) % 60LU);

  fprintf (aus, deutsch ? "%lu Sekunden\n" : "%lu seconds\n", Zeit % 60LU);

  return Zeit;
}
