/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2015-2017,2023 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS
#endif

#ifndef __STDC_CONSTANT_MACROS
#define __STDC_CONSTANT_MACROS
#endif

#include <stdint.h>
#include <string.h>
#include "akfnetz.h"

/*
Es werden SI-Einheiten ausgegeben.
Mit den binaeren Einheiten klappt die Rundung so nicht.
*/

#define Byte      UINTMAX_C (1)
#define Kilobyte  UINTMAX_C (1000)	// Tausend
#define Megabyte  UINTMAX_C (1000000)	// Million
#define Gigabyte  UINTMAX_C (1000000000)	// Milliarde
#define Terabyte  UINTMAX_C (1000000000000)	// Billion
#define Petabyte  UINTMAX_C (1000000000000000)	// Billiarde
#define Exabyte   UINTMAX_C (1000000000000000000)	// Trillion
#if UINTMAX_MAX > UINT_LEAST64_MAX	// mehr als 64 Bit?
#define Zettabyte UINTMAX_C (1000000000000000000000)	// Trilliarde
#define Yottabyte UINTMAX_C (1000000000000000000000000)	// Quadrillion
#define Maximaleinheit Yottabyte
#else
#define Maximaleinheit Exabyte
#endif

static size_t
Einheit (char *p, size_t l, uintmax_t Wert, uintmax_t Einh, const char *Name)
{
  uintmax_t Einheitsbetrag;

  // ganzzahliger Wert auf Einheit gerundet
  if (Wert <= (UINTMAX_MAX - (Maximaleinheit / 2)))
    Einheitsbetrag = (Wert + (Einh / 2)) / Einh;
  else
    Einheitsbetrag = UINTMAX_MAX / Maximaleinheit;

  return snprintf (p, l, "%ju %s", Einheitsbetrag, Name);
}


extern size_t
akfnetz_Datengroessenstring (char *p, size_t l, uintmax_t Wert)
{
  size_t nl;

#ifdef Yottabyte
  if (Wert >= Yottabyte)
    nl = Einheit (p, l, Wert, Yottabyte, "YB");
  else if (Wert >= Zettabyte)
    nl = Einheit (p, l, Wert, Zettabyte, "ZB");
  else
#endif
  if (Wert >= Exabyte)
    nl = Einheit (p, l, Wert, Exabyte, "EB");
  else if (Wert >= Petabyte)
    nl = Einheit (p, l, Wert, Petabyte, "PB");
  else if (Wert >= Terabyte)
    nl = Einheit (p, l, Wert, Terabyte, "TB");
  else if (Wert >= Gigabyte)
    nl = Einheit (p, l, Wert, Gigabyte, "GB");
  else if (Wert >= Megabyte)
    nl = Einheit (p, l, Wert, Megabyte, "MB");
  else if (Wert >= Kilobyte)
    nl = Einheit (p, l, Wert, Kilobyte, "kB");
  else
    nl = Einheit (p, l, Wert, Byte, "B");

  return nl;
}
