/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2015-2017 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <stdbool.h>
#include "akfnetz.h"

extern bool
akfnetz_cgi_Formulardaten (void)
{
  size_t Laenge = 0;
  char *Methode = getenv ("REQUEST_METHOD");
  char *Laengenangabe = getenv ("CONTENT_LENGTH");
  char *Typ = getenv ("CONTENT_TYPE");

  if (Laengenangabe)
    Laenge = (size_t) strtoul (Laengenangabe, NULL, 10);

  akfnetz_Formularfreigabe ();

  if (Laenge > 0 && Methode && !strcmp ("POST", Methode)
      && Typ && !strcasecmp ("application/x-www-form-urlencoded", Typ))
    akfnetz_Formulardaten_einlesen (Laenge);
  else				// jede andere Methode
    akfnetz_Formulardaten (getenv ("QUERY_STRING"));

  return (bool) (akfnetz_Formularfelder != NULL);
}
