/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2015,2016,2018 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "akfnetz.h"
#include <unistd.h>
#include <string.h>
#include <errno.h>

extern int
akfnetz_Ausgabe (int fd, const void *Puffer, size_t Laenge)
{
  const char *s;

  if (!Puffer)
    return 0;

  s = Puffer;
  while (Laenge)
    {
      ssize_t r;

      do
	r = write (fd, s, Laenge);
      while (r < 0 && errno == EINTR);

      if (r < 0)
	return -1;

      s += r;
      Laenge -= r;
    }

  return 0;
}


extern int
akfnetz_ausgeben (int fd, const char *s)
{
  if (!s || !*s)
    return 0;

  return akfnetz_Ausgabe (fd, s, strlen (s));
}
