/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2016 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "akfnetz.h"
#include <sys/socket.h>
#include <string.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int
akfnetz_Adresszuweisung (int af, const char *a, void *Ziel)
{
  int e;
  size_t l;

  e = inet_pton (af, a, Ziel);

  if (e == 0 && AF_INET6 == af && (l = strlen (a)) <= 15)
    {
      // ob er's wohl als gemappte IPv4-Adresse akzeptiert?
      char Adresse[INET6_ADDRSTRLEN];
      memcpy (Adresse, "::FFFF:", 7);
      memcpy (Adresse + 7, a, l + 1);
      e = inet_pton (AF_INET6, Adresse, Ziel);
    }

  return e;
}
