/* SPDX-License-Identifier: GPL-3.0-or-later */
/*
 * Copyright (c) 2016 Andreas K. Foerster <akf@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#define _DEFAULT_SOURCE
#define _BSD_SOURCE

#include "akfnetz.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

char *
akfnetz_Adressentext (int af, const void *Adresse, char *Ziel, size_t Groesse)
{
  const char *e;

  if (AF_INET6 == af)
    {
      const struct in6_addr *a;
      a = (const struct in6_addr *) Adresse;
      if (!IN6_IS_ADDR_V4MAPPED (a))
	e = inet_ntop (AF_INET6, Adresse, Ziel, Groesse);
      else			// IPv4-Adresse als solche ausgeben
	e = inet_ntop (AF_INET, a->s6_addr + 12, Ziel, Groesse);
    }
  else
    e = inet_ntop (af, Adresse, Ziel, Groesse);

  return (char *) e;
}
