.\" Process this file with
.\" groff -man -Tutf8 akfquery.de.man
.\"
.
.TH "akfscraper" 1 2025-01-06 akfnetz
.nh
.
.\" Makros .TQ .EX .EE aus groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.de TQ
.br
.ns
.TP \\$1
..
.
.\" Beispielanfang
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" Beispielende
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.SH NAME
akfscraper \- HTML/XHTML in reinen Text verwandeln
.
.SH SYNTAX
.B akfscraper
.RI [ Optionen "] [" HTML-Dateien ]
.
.SH BESCHREIBUNG
.
Das Programm
.b akfscraper
verwandelt HTML- oder XHTML-Daten in reinen Text bzw. Markdown.
.PP
Wenn keine Dateien angegeben sind, liest es von der Standardeingabe.
Wenn nicht die Option
.I -o
verwendet wird, schreibt es auf die Standardausgabe.
Das hei\[ss]t, es kann als Filter eingesetzt werden.
.PP
Die Ausgabe ist immer UTF-8 kodiert.
Als Eingabe-Kodierungen werden
UTF-8, ISO-8859-1 oder Codepage\~1252 unterst\[:u]tzt.
.PP
Links werden am Ende als Referenzen aufgef\[:u]hrt.
.PP
.
.SH OPTIONEN
.
.TP
-h
.TQ
--help
.TQ
--Hilfe
Zeigt eine kurze Hilfe an.
.PP
.TP
-V
.TQ
--version
.TQ
--Version
Zeigt die Version an.
.PP
.TP
-u
Die Eingabe soll als UTF-8 kodiert interpretiert werden,
wenn keine Meta-Angabe oder XML-Signatur etwas anderes sagt.
.PP
.TP
.RI "-c " Zeichensatz
.TQ
.RI "--charset " Zeichensatz
.TQ
.RI "--Zeichesatz " Zeichensatz
Wenn
.I Zeichensatz
als UTF-8 oder UTF8 angegeben ist,
soll die Eingabe als UTF-8 kodiert interpretiert werden,
wenn keine Meta-Angabe oder XML-Signatur etwas anderes sagt.
(Langform von -u f\[:u]r Kompatiblit\[:a]t)
.PP
.TP
-l
.TQ
--Links
.TQ
--links
Externe Links als Referenzen ausgeben.
.PP
.TP
.RI "-L " Nr
Wie -l, aber
.I Nr
Links am Anfang ignorieren
.PP
.TP
-n
Keine automatischen Zeilenumbr\[:u]che einf\[:u]gen.
(Lange Zeilen)
.PP
.TP
-e
.TQ
--extended
.TQ
--erweitert
Die Ausgabe soll Terminal-Steuersequenzen enthalten (SGR-Codes).
.PP
.TP
.RI "-o " \[dq]Datei\[dq]
.TQ
.RI "--output=" \[dq]Datei\[dq]
.TQ
.RI "--Ausgabe=" \[dq]Datei\[dq]
.TQ
.RI "--Datei=" \[dq]Datei\[dq]
Die Ausgabe soll in die
.I Datei
geschrieben werden, statt sie auf der Standardausgabe auszugeben.
.PP
.TP
-f
.TQ
--force
.TQ
--forciere
Bestehende Datei \[:u]berschreiben
.
.SH BEISPIELE
.
.EX
akfscraper -l -o Artikel.text Seite1.html Seite2.html Seite3.html
.EE
.PP
.EX
akfscraper -e -l Artikel.html | less -r
.EE
.PP
.EX
curl -sL "https://gnu.org" | akfscraper -e -l | less -r
.EE
.PP
Mailcap:
.EX
text/html; akfscraper -l -c %{charset}; copiousoutput
.EE
.
.SH AUTOREN
.
Copyright \(co 2025 Andreas K. F\[:o]rster
.PP
Dieses Programm ist freie Software.
Sie k\[:o]nnen es unter den Bedingungen
der GNU General Public License, wie von der Free Software Foundation
ver\[:o]ffentlicht, weitergeben und/oder modifizieren,
entweder gem\[:a]\[ss]
Version 3 der Lizenz oder (nach Ihrer Option)
jeder sp\[:a]teren Version.
.PP
Die Ver\[:o]ffentlichung dieses Programms erfolgt in der Hoffnung,
dass es Ihnen von Nutzen sein wird, aber
.BR "ohne irgendeine Garantie" ,
sogar ohne die implizite Garantie der
.B Marktreife
oder der
.BR "Verwendbarkeit f\[:u]r einen bestimmten Zweck" .
Details finden Sie in der GNU General Public License.
.PP
Sie sollten ein Exemplar der GNU General Public License zusammen
mit diesem Programm erhalten haben.
Falls nicht, siehe <http://www.gnu.org/licenses/>.
.PP
.
.SH "SIEHE AUCH"
.BR more (1)
.BR less (1)
.BR akfweb-dl (1)
.BR curl (1)
.PP
https://akfoerster.de/p/akfnetz/
