.\" Process this file with
.\" groff -man -Tutf8 akfquery.de.man
.\"
.
.TH "akfquery" 1 2024-09-22 akfnetz
.nh
.
.\" Makros .TQ .EX .EE aus groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.de TQ
.br
.ns
.TP \\$1
..
.
.\" Beispielanfang
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" Beispielende
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.SH NAME
akfquery \- Formulardaten per CGI in Shellskripten nutzen
.
.SH SYNTAX
.B akfquery
.I Feldname
.RI [ Alternative ]
.
.SH BESCHREIBUNG
Das Programm
.B akfquery
kann genutzt werden, um Formulare, die mit der
.BR GET -Methode
\[:u]bertragen wurden, in Shellskripten zu verwenden.
.PP
Es muss ein
.I Feldname
angeben sein.
Das Programm gibt den Feldwert dekodiert auf der Standardausgabe aus.
Wenn das Feld nicht existiert, oder leer ist, wird die
.I Alternative
ausgegeben, falls vorhanden.
Ansonsten wird nichts ausgegeben.
.PP
Falls das Feld mehrere Werte hat, gibt das Programm mehrere Zeilen aus.
Dies kann zum Beispiel bei Checkboxen der Fall sein.
.PP
Spezielle HTML-Zeichen (<>&"') werden als HTML-Entit\[:a]ten ausgegeben.
.
.SS Warnung
.
Shell-Skripte sind f\[:u]r schnelle Notl\[:o]sungen
oder Entw\[:u]rfe in lokalen, privaten Netzen verwendbar,
aber kaum geeignet f\[:u]r den ernsthaften Einsatz im offenen Internet.
.
.SH UMGEBUNGSVARIABLEN
.TP
QUERY_STRING
enth\[:a]lt Formulardaten bei der GET-Methode
.
.SH BEISPIELE
.EX
# \[:o]fter verwendete Elemente in Variable speichern
Name=$(akfquery Name "Unbekannter")

echo "<p>Hallo $Name.</p>"

# Bei einmaliger Ausgabe kann das direkt ausgegeben werden.
# Die Zeilenumbr\[:u]che st\[:o]ren bei HTML nicht weiter.
echo "<p>Alter:"
akfquery Alter
echo "</p>"

# Hobby ist zB. mit Checkboxen realisiert
echo "<ul>"
for i in $(akfquery Hobby "keine Hobbys")
do
  echo "<li>$i</li>"
done
echo "</ul>"
.EE
.
.SH AUTOREN
.
Copyright \(co 2018 Andreas K. F\[:o]rster
.PP
Dieses Programm ist freie Software.
Sie k\[:o]nnen es unter den Bedingungen
der GNU General Public License, wie von der Free Software Foundation
ver\[:o]ffentlicht, weitergeben und/oder modifizieren,
entweder gem\[:a]\[ss]
Version 3 der Lizenz oder (nach Ihrer Option)
jeder sp\[:a]teren Version.
.PP
Die Ver\[:o]ffentlichung dieses Programms erfolgt in der Hoffnung,
dass es Ihnen von Nutzen sein wird, aber
.BR "ohne irgendeine Garantie" ,
sogar ohne die implizite Garantie der
.B Marktreife
oder der
.BR "Verwendbarkeit f\[:u]r einen bestimmten Zweck" .
Details finden Sie in der GNU General Public License.
.PP
Sie sollten ein Exemplar der GNU General Public License zusammen
mit diesem Programm erhalten haben.
Falls nicht, siehe <http://www.gnu.org/licenses/>.
.PP
.
.SH "SIEHE AUCH"
.BR akfwebserver (1)
.PP
https://akfoerster.de/p/akfnetz/
