.\" Process this file with
.\" groff -man -Tutf8 akfgopherserver.en.man
.\"
.
.TH "akfgopherserver" 1 2025-10-21 akfnetz
.
.\" Makros .TQ .EX .EE aus groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.de TQ
.br
.ns
.TP \\$1
..
.
.\" Start example.
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" End example.
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.SH NAME
akfgopherserver \- Gopher-Server
.
.SH SYNOPSIS
.BI "akfgopherserver [" Options ]
.
.SH DESCRIPTION
.
The program
.B akfgopherserver
is a server for the Gopher protocol (not Gopher+).
.PP
Gopher is a simple Internet protocol, which is mainly used
to distribute information in form of plain text files over the
net.
Other files can be offered for download.
.PP
This server can be started by regular users when needed.
By default, it only responds to requests from local networks,
while blocking access from the Internet.
.PP
If this server is run by a normal, non-privileged user, it uses port
.BR 7070 . 
This port must then also be explicitly specified when called up in the
client.
For example:
.BR gopher://localhost:7070 .
.PP
If the program is running in a terminal in the foreground,
you can simply cancel it with the key combination
.BR [Ctrl] + [C] .
Otherwise, you can also terminate it using the
.BR killall (1)
or
.BR kill (1) .
.PP
.
.SH OPTIONS
.
.TP
-h
.TQ
--help
.TQ
--Hilfe
shows a short help
.TP
-V
.TQ
--version
.TQ
--Version
shows the version
.PP
.TP
-t
.TQ
--text
unknkown filenames should be interpreted as text files (type 0).
Otherwise they are binary files (type 9).
.PP
.TP
.RI "-d " directory
.TQ
.RI --directory= directory
.TQ
.RI --Verzeichnis= directory
make that
.I directory
the root directory.
Without this option the current working directory, from which the
program is started becomes the root directory.
.PP
.TP
.RI "-N " Servername
.TQ
.RI --Servername= Servername
.TQ
.RI --servername= Servername
sets the
.IR Servername .
.IP
International domain names must be created in
ASCII Compatible Encoding (ACE).
.PP
.TP
.RI "-p " port_number
.TQ
.RI --port= port_number
.TQ
.RI --Port= port_number
sets the
.IR port_number .
This is the port on which this server listens.
.PP
.TP
.RI --Serverport= port_number
.TQ
.RI --serverport= port_number
set a virtual different
.IR port_number .
If the server is controlled by a frontend,
you can set the port_number of that with this.
.PP
.TP
-l
.TQ
--localhost
Only listens on the
.BR localhost -address
for IPv4.
That is
.BR 127.0.0.1 .
So with that the server should be only accessible on the same machine
and not over the network.
.PP
.TP
.RI "-a " IP-address
.TQ
.RI --address= IP-addres
.TQ
.RI --Adresse= IP-address
binds the server to the given
.IR IP-address .
.IP
This can be used to limit the reachability to a local network.
That is more secure than the built in filter.
.PP
.TP
-4
.TQ
--IPv4
use IPv4
.PP
.TP
-6
.TQ
--IPv6
use IPv6 (default)
.br
The server may however decide to degrade it to an IPv4 connection at will.
.IP
Whether IPv4 connections are also supported in IPv6 mode depends
on the operating system and possibly its settings.
.PP
.TP
.RI "-u " user_ID
.TQ
.RI --Nutzer= user_ID
If the server is started with root privileges (real user_ID),
you can use this option to specify another
.I user_ID
with whose privileges it should ultimately run.
The
.I user_ID
can be a name or a numerical indication.
.PP
.TP
-D
.TQ
--daemon
starts the server in the background as daemon
.PP
.TP
--open
.TQ
--offen
.TQ
--Internet
opens the server to the whole Internet.
.IP
.B Attention!
This turns off the filter for private networks.
The server can be accessed via the Internet.
You may also have to release the port on your router for this.
.PP
.TP
-i
.TQ
--inetd
Accepts requests on standard input and outputs responses on standard 
output.
If the standard input is a socket, the connection data is read from it.
.PP
.
.SH ENVIRONMENT
.
.TP
HOSTNAME, HOST
If one of these variables is set, this is taken as the server name.
.PP
.TP
LC_ALL, LC_MESSAGES, LANG
these variables influence the language selection for the screen.
.PP
.
.SH DETAILS
.
.SS Files
.
Files that have no dot in the name (and are not executable) are recognized 
as text files.
One can also use the file extensions
.BR .text " or " .txt .
These file extensions are not displayed
and underscores are converted to spaces.
.PP
Files in the Markdown-format with the extension
.BR .md " or " .markdown
are also recognized as text files.
.PP
For Gopher text files must have less than 80 characters per line.
To achieve this, you may use the command
.BR fmt (1).
.PP
Many more file extensions for different file formats are recognized.
.PP
Files whose name starts with a period are hidden,
but can be retrieved. The same ist true for directories.
.
.SS Directories
.
For directories, you can specify a different display name by creating a 
file called
.BR gophertag .
So you can keep the path short and still get a reasonable indication.
For example, go to a directory called
.B rel/
and enter the following:
.br
.B  $ echo 'religious writings' > gophertag
.PP
Usually the menu is created automatically by file listing.
.PP
.
.SS Menus
.
You can also create your own menus.
This not only looks better, but is inevitable for several possibilities of Gopher.
.PP
To create your own menus, a file called
.B gophermap
must be created in a directory.
Basically, each line represents a menu item.
However, lines starting with a hash (#) are comments and are ignored.
Lines that do not contain a <TAB> character become information lines ('i').
This also applies to blank lines.
Lines of information should not carry important content, as they may be ignored by the client.
Content should be in text files.
.PP
The format of a
.B gophermap
resource line is:
.br
.IR Xname <TAB> selector <TAB> host <TAB> port
.PP
.TP
.I X
is the gopher type
(see section
.BR "Gopher Types" ).
.TP
.I name
is an explanation of the resource
.TP
.I selector
is the path to resource
.TP
.I host
is the hostname
.TP
.I port
is the port number
.PP
If you do not specify the host and the port, the current server is entered
for this.
In this case, it is also sufficient to specify only the file name as
the selector.
Then the path will be supplemented, if nessesary.
Two dots as a selector ("..") lead to the parent directory.
However, if there is a slash in the selector, it is transmitted unchanged.
You can simply enter a slash for the main directory.
.PP
Please note that if the host and port are specified, the selector is always
transmitted unchanged.
.PP
At the end of the file there should be a line that contains only one dot
('.').
This completes the menu.
If instead there is a line at the end that contains only an asterisk ('*'),
an automatic file listing will be appended below.
.PP
If you generally prefer an automatic file listing, and only want to add
individual other entries, you can add files with the file
extension
.BR .gophermap ,
which include only one, or a few menu lines.
The name of such files is never displayed,
but it has an influence on the sorting.
Whether such files are finished with a final character,
and with which one,
is irrelevant.
.PP
.
.SS Gopher Types
.
From the original specification:
.TP
0
Text file
.TP
1
Directory
.TP
2
CCSO phone-book server
.TP
3
Error
.TP
4
BinHexed Macintosh file
.TP
5
binary Archive
.TP
6
uuencoded file
.TP
7
Index-Search server
.TP
8
Telnet session
.TP
9
Binary
.TP
+
Redundant server
.TP
T
TN3270 session
.TP
g
GIF format graphics file
.TP
I
other Image file
.PP
extensions
.PP
.TP
i
Informational message
.TP
d
Documentation
.TP
h
HTML file
.TP
X
XML file
.TP
s
Sound file
.TP
;
Movie file
.TP
c
Calendar file
.TP
M
MIME file
.PP
Other extentions can be used and are in use...
.PP
.
.
.SH EXAMPLE
.
Example for a
.B gophermap
file.
Instead of "<TAB>" you must of course use a TAB character.
.PP
.EX
# First a greeting
Welcome at exampleserver

# Link to the file info in the main directory
0Information<TAB>/info
# Subdirectory
1Books and texts<TAB>books
# External server
1Floodgap<TAB>/<TAB>gopher.floodgap.com<TAB>70
# Telnet session
8Telehack<TAB>none<TAB>telehack.com<TAB>23
# Links for other protocols are introduced with "URL:"
hWebsite<TAB>URL:https://akfoerster.de/
\&.
.EE
.
.SH AUTHORS
.
Copyright \(co 2025 Andreas K. F\[:o]rster
.
.SH LICENSE
.
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.
.PP
This program is distributed in the hope that it will be useful, but
.BR "WITHOUT ANY WARRANTY" ;
without even the implied warranty of
.BR MERCHANTABILITY " or " "FITNESS FOR A PARTICULAR PURPOSE" .
See the GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program.
If not, see <http://www.gnu.org/licenses/>.
.PP
.
.SH "SEE ALSO"
.BR akfgb (1),
.BR akfgopher-dl (1)
.br
RFC\~1436
.PP
gopher://akfoerster.de:47520/1soft/akfnetz
.br
https://akfoerster.de/p/akfnetz/
