.\" Process this file with
.\" groff -man -Tutf8 akfbase64.en.man
.\"
.
.TH "akfbase64" 1 2025-02-27 akfnetz
.nh
.
.\" Makros .TQ aus groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.de TQ
.br
.ns
.TP \\$1
..
.
.
.SH NAME
akfbase64 \- base64 encoder and decoder
.
.SH SYNOPSIS
.B akfbase64
.RI [ options "] [" input\~file "] [" output\~file ]
.br
.B akfbase64
.IR -z " [" -u ]
.
.SH DESCRIPTION
.
Base64 is a method to convert binary data into plain ASCII.
.PP
When no input files are given, the program reads from standard input
and writes to standard output.
That means it can be used as a filter.
.PP
For encoding it outputs up to 76 characters per line.
For decoding it ignores spaces, line breaks
and other control codes.
.PP
The variant base64url is more suitable for URLs and file names.
Instead of the characters '+' and '/' it uses '-' and '_'.
.PP
.
.SH OPTIONS
.
.TP
-h
.TQ
--help
shows help
.PP
.TP
--version
show licensing information
.PP
.TP
-u
encode as the variant base64url
.PP
.TP
-n
no line breaks
.PP
.TP
-m
encode in compatibility mode for
.BR uudecode (1)
with head and foot.
The input file must be provided.
.PP
.TP
-d
decode (base64 or base64url)
.PP
.TP
-z
outputs one line of random characters (/dev/urandom)
.br
No input file may be provided.
Can be combined with the option -u.
.PP
.
.SH AUTHORS
.
Copyright \(co 2025 Andreas K. F\[:o]rster
.PP
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.
.PP
This program is distributed in the hope that it will be useful, but
.BR "WITHOUT ANY WARRANTY" ;
without even the implied warranty of
.BR MERCHANTABILITY " or " "FITNESS FOR A PARTICULAR PURPOSE" .
See the GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program.
If not, see <http://www.gnu.org/licenses/>.
.PP
.
.SH "SEE ALSO"
RFC\~4648
.br
https://akfoerster.de/p/akfnetz/
