#!/bin/sh

# geschrieben von Andreas K. Förster <http://akfoerster.de>
# Lizenz: CC0
# https://creativecommons.org/publicdomain/zero/1.0/deed.de
# SPDX-License-Identifier: CC0-1.0

# benötigt akfquery
PATH=$PATH:.

# Man spricht deutsch
LANG=de_DE.utf8
LC_MESSAGES="$LANG"
export LANG LC_MESSAGES


if [ -z "$GATEWAY_INTERFACE" ]
then
  echo "Ey, das sollte nur über einen Webserver aufgerufen werden." >&2
  exit 1
fi

set -C
tmp="/tmp/mancgi$$"
trap "rm -f $tmp" 0 TERM HUP PIPE INT
# Die Prozess-ID im Dateinamen verhindert, dass sich
# mehrere Prozesse in die Quere kommen.


Kopfende ()
{
  echo
  test "$REQUEST_METHOD" = "HEAD" && exit
}


Fehler ()
{
echo "Status: 404 Not Found"
echo "Content-Type: text/html; charset=utf-8"
Kopfende

cat <<ENDE
<!DOCTYPE html><html>
<body style="background-color:#FCC; color:#000">
<h1>Fehler: nicht gefunden</h1>

<p>Tut mir leid, aber dazu habe ich nichts gefunden.</p>

<p>&bull; <a href="$SCRIPT_NAME">Neue Anfrage</a></p>

</body>
</html>
ENDE

exit 0
}


Formular ()
{
echo "Content-Type: text/html; charset=utf-8"
Kopfende

cat <<ENDE
<!DOCTYPE html>
<html>
<head>
<title>Manpage</title>
</head>

<body>
<h1>Manpage</h1>

<p>
Hallo ${REMOTE_USER:-"Computer-Nutzer"},
wozu hättest du denn gern eine Anleitung?
</p>

<form action="$SCRIPT_NAME" method="GET">
<input type="search" name="Anleitung" required>
<input type="submit" value="lesen">
<br>
<select name="Abschnitt">
<option value="" selected>unbestimmter Abschnitt</option>
<option value="1">1 Dienstprogramme für Benutzer</option>
<option value="2">2 Systemaufrufe</option>
<option value="3">3 Bibliotheksfunktionen</option>
<option value="4">4 Gerätedateien</option>
<option value="5">5 Dateiformate</option>
<option value="6">6 Spiele</option>
<option value="7">7 Konventionen &amp; Protokolle</option>
<option value="8">8 Administration</option>
</select>
</form>

<h2>Tipps</h2>

<ul>
<li>Manche Begriffe haben verschiedene Definitionen in verschiedenen
Abschnitten.</li>
<li>Jeder Abschnitt hat eine Seite namens „intro“.</li>
<li>Eine allgemeine Einführung in die Verwendung von Unix-Befehlen
findet man in <a href="?Anleitung=intro;Abschnitt=1">intro(1)</a>.</li>
<li>Leider funktioniert mit der HTML-Darstellung einiges nicht.
Zum Beispiel Tabellen.</li>
</ul>

</body></html>
ENDE

exit 0
}


[ -z "$QUERY_STRING" ] && Formular

Anleitung=$(akfquery Anleitung)
[ -z "$Anleitung" ] && Fehler

Abschnitt=$(akfquery Abschnitt)

man -Thtml $Abschnitt "$Anleitung" >$tmp 2>/dev/null || Fehler
# $Anleitung zum Schutz in Anführungsstriche!
# -Thtml funktioniert wohl nur mit groff

echo "Content-Type: text/html; charset=utf-8"
Kopfende
cat $tmp
