.\" Process this file with
.\" groff -man -Tutf8 akfwebserver.de.man
.\"
.
.TH "akfwebserver" 1 2025-04-02 akfnetz
.nh
.
.\" Makros .TQ .EX .EE aus groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.de TQ
.br
.ns
.TP \\$1
..
.
.\" Start example.
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" End example.
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.SH NAME
akfwebserver \- HTTP-Server
.
.SH SYNTAX
.BI "akfwebserver [" Optionen ]
.
.SH BESCHREIBUNG
.
Das Programm
.B akfwebserver
ist ein kleiner Webserver.
.PP
Es kann von normalen Benutzern bei Bedarf gestartet werden.
Es antwortet per Voreinstellung nur
auf Zugriffe von lokalen Netzen,
w\[:a]hrend er Zugriffe aus dem Internet blockiert.
.PP
Er kann aber auch als Webserver f\[:u]r das Internet
mit einer zentralen Konfigurationsdatei eingesetzt werden.
F\[:u]r HTTPS wird zus\[:a]tzliche Software ben\[:o]tigt.
Zum Beispiel stunnel. 
.PP
Wenn dieser Server von einem normalen, nicht privilegierten Benutzer
aufgerufen wird, verwendet er den Port
.BR 8080 .
Dieser Port muss dann auch beim Abruf im Browser explizit mit
angegeben werden.
Zum Beispiel:
.BR http://localhost:8080/ .
.PP
Wenn das Programm in einem Terminal im Vordergrund l\[:a]uft,
kann man es einfach mit der Tastenkombination
.BR [Strg] + [C]
abbrechen.
Ansonsten kann man es auch \[:u]ber die Befehle
.BR killall (1)
oder
.BR kill (1)
beenden.
.PP
Das Programm ist mehrsprachig:
Gr\[:o]\[ss]tenteils wird Deutsch, Englisch und Esperanto
unterst\[:u]tzt.
Verzeichnisdarstellungen unterst\[:u]tzen mehr Sprachen.
Die Sprache bei Verzeichnisdarstellungen wird von der jeweiligen
Browser-Einstellung beeinflusst (Accept-Language),
kann aber auch manuell gew\[:a]hlt werden.
Ausgaben am Terminal sind von der Systemeinstellung abh\[:a]ngig.
.PP
.B Achtung:
Die Option --gzip wurde \[:u]berarbeitet.
Dateien, die mit einem Punkt beginnen, sind abrufbar,
au\[ss]er sie beginnen mit
.BR .ht .
Das Verzeichnis \[Fc]/cgi-bin\[Fo] wird anders behandelt.
.PP
.
.SH OPTIONEN
.TP
-h
.TQ
--help
.TQ
--Hilfe
Zeigt eine kurze Hilfe an.
.TP
-V
.TQ
--version
.TQ
--Version
Zeigt die Version an.
.TP
.RI "-c " Datei
.TQ
.RI --config= Datei
.TQ
.RI --Konfiguration= Datei
Lies die Konfiguration aus der Datei.
Erlaubt sind Optionen ohne die Bindestriche,
eine Option pro Zeile.
Leerzeilen und Zeilen, die mit # beginnen, werden ignoriert.
Die Konfigurationsdatei kann auch weitere Konfigurationsdateien
aufrufen.
.TP
.RI "-d " Verzeichnis
.TQ
.RI --directory= Verzeichnis
.TQ
.RI --Verzeichnis= Verzeichnis
Legt das angegebene
.I Verzeichnis
als Wurzelverzeichnis fest.
Ohne diese Angabe wird das Verzeichnis, in dem das Programm gestartet
wurde zum Wurzelverzeichnis.
.PP
.TP
--virtual
.TQ
--virtuell
Aktiviert Namensbasiertes Virtual Hosting.
.IP
Im Wurzelverzeichnis m\[:u]ssen dabei Unterverzeichnisse
mit den unterst\[:u]tzen Domainnamen kleingeschrieben angelegt werden.
Somit gibt es verschiedene Wuzelverzeichnisse
f\[:u]r die unterschiedlichen Domainnamen.
Wenn ein Verzeichnis f\[:u]r mehrere Domainnamen gelten soll,
kann man symbolische Links anlegen.
Domainnamen, f\[:u]r die kein Unterverzeichnis gefunden wird,
oder in dessen Verzeichnis der Server nicht wechseln kann,
erzeugen eine Fehlerseite (403).
.IP
Internationale Domainnamen m\[:u]ssen in ASCII-kompatibler Schreibweise (ACE)
angelegt werden.
.IP
CGI-Variablen werden automatisch angepasst.
.IP
Ohne diese Option wird der Domainname ignoriert.
.PP
.TP
.RI "-N " Servername
.TQ
.RI --Servername= Servername
.TQ
.RI --servername= Servername
Legt den
.IR Servername n
fest.
(F\[:u]r CGI.)
.IP
Internationale Domainnamen m\[:u]ssen in ASCII-kompatibler Schreibweise (ACE)
angegeben werden.
.IP
Bei Verwendung von Virtual Hosting wird dieser Name nicht verwendet.
.PP
.TP
.RI "-p " Portnummer
.TQ
.RI --port= Portnummer
.TQ
.RI --Port= Portnummer
Legt die
.I Portnummer
fest.
Dies ist der Port auf dem dieser Server lauscht.
[IP]
.PP
.TP
.RI --Serverport= Portnummer
.TQ
.RI --serverport= Portnummer
Legt eine nominelle andere
.I Portnummer
fest.
Falls der Server \[:u]ber ein Frontend gesteuert wird,
kann man hiermit dessen Portnummer angeben.
Dieser Port wird f\[:u]r die CGI-Variable SERVER_PORT verwendet.
[IP, CGI]
.PP
.TP
-l
.TQ
--localhost
H\[:o]rt nur auf die
.BR localhost -Adresse
f\[:u]r IPv4.
Das ist
.BR 127.0.0.1 .
Damit sollte der Server nur von dem selben Rechner aus erreichbar sein.
[IP]
.PP
.TP
.RI "-a " IP-Adresse
.TQ
.RI --address= IP-Adresse
.TQ
.RI --Adresse= IP-Adresse
Bindet den Server an die angegebene
.IR IP-Adresse .
.IP
Dieses kann man nutzen, um die Erreichbarkeit auf ein lokales Netzwerk
zu begrenzen.
Das ist sicherer, als der eingebaute Filter.
[IP]
.PP
.TP
-4
.TQ
--IPv4
IPv4 verwenden.
[IP]
.PP
.TP
-6
.TQ
--IPv6
IPv6 verwenden. (Vorgabe)
[IP]
.br
Der Server beh\[:a]lt sich jedoch das Anrecht vor, die Verbindung nach
Gutd\[:u]nken zu einem gemeinen IPv4 zu degradieren.
.IP
Ob im IPv6-Modus auch IPv4-Verbindungen unterst\[:u]tzt werden,
h\[:a]ngt vom Betriebssystem und eventuell dessen Einstellungen ab.
.PP
.TP
.RI "-U " Socketpfad
.TQ
.RI --socket= Socketpfad
.TQ
.RI --Socket= Socketpfad
Unix-Socket anlegen.
.IP
Es muss ein absoluter Pfad angegeben werden.
Der Server kann dann nur \[:u]ber diesen Socket angesprochen werden.
Das funktioniert nur f\[:u]r Programme auf dem selben Ger\[:a]t.
Der Server ist damit nicht \[:u]ber ein Netzwerk erreichbar.
Das ist insbesondere sinnvoll, wenn der Server von einem Frontend gesteuert
wird.
.IP
Als
.I Socketpfad
eignet sich zum Beispiel \[Fc]/tmp/http\[Fo].
Der Socket ist f\[:u]r alle Benutzer des Ger\[:a]tes verwendbar.
Falls man auch das einschr\[:a]nken m\[:o]chte, kann man ihn in
einem Verzeichnis mit eingeschr\[:a]nkten Zugriffsrechten anlegen
lassen.
.PP
.TP
--privacy
.TQ
--Datenschutz
Die IP-Adresse oder der Rechnername steht dann nicht im Logbuch.
Bei angemeldeten Benutzern wird nur das Stichwort \[Fc]login\[Fo]
anstelle des Namens im Logbuch verzeichnet.
.IP
F\[:u]r CGI-Programme ist die IP-Adresse und eventuell der Rechnername
aber zug\[:a]nglich.
.PP
.TP
.RI "-L " Datei
.TQ
.RI --log= Datei
Logbuch in die
.I Datei
schreiben
.PP
.TP
-s
.TQ
--still
nichts ausgeben
.PP
.TP
-v
.TQ
--verbose
.TQ
--wortreich
ausf\[:u]hrlichere Ausgabe
.PP
.TP
-g
.TQ
--gzip
Auch nach komprimierten Dateien mit der Dateiendung \[Fc].gz~\[Fo] suchen,
wenn der Klient gzip unterst\[:u]tzt. (Accept-Encoding)
.IP
Der Dateiname muss mit einer Tilde enden.
Dadurch wird er auch beim automatischen Verzeichnisindex nicht angezeigt.
.IP
Es findet keine automatische Kompression statt.
Diese Dateien m\[:u]ssen zus\[:a]tzlich zu den unkomprimierten Dateien
vorhanden sein.
.PP
.TP
.RI "-G " Datei
.TQ
.RI --cgi-file= Datei
.TQ
.RI --cgi-Datei= Datei
Die angegebene Datei als CGI-Programm kennzeichnen.
Es k\[:o]nnen so mehrere Dateien gekennzeichnet werden.
Diese Dateien m\[:u]ssen ausf\[:u]hrbar sein.
Der Vorteil dieser Methode liegt darin,
dass man sch\[:o]nere Pfade erzeugen kann,
und dass CGI-Programme nicht ohne Weiteres
als solche erkennbar sind.
CGI-Programme k\[:o]nnen so \[:u]brigens auch
die Erweiterung \[Fc].html\[Fo] haben.
.PP
.TP
-C
.TQ
--cgi
Aktiviert CGI-Unterst\[:u]tzung f\[:u]r Dateien mit der Dateiendung
.BR .cgi .
Diese Dateien m\[:u]ssen ausf\[:u]hrbar sein.
Sie k\[:o]nnen in jedem exportierten Verzeichnis liegen.
F\[:u]r Verzeichnisaufrufe kann man auch
.BR index.cgi -Dateien
anlegen.
.PP
.TP
.RI "-e " Erweiterung = Aktion
.TQ
.RI --extension= Erweiterung = Aktion
.TQ
.RI --Erweiterung= Erweiterung = Aktion
.IR Aktion " f\[:u]r Datei-" Erweiterung " festlegen."
Die
.I Aktion
sollte ein Pfad zu einem CGI-Programm sein.
Dieses kann auf die Datei \[:u]ber die Variable PATH_TRANSLATED zugreifen.
.IP
Mit dieser Option kann man unter anderem auch PHP anbinden.
.PP
.TP
.RI "-M " Maske
.TQ
.RI --cgi-umask= Maske
CGI Programme mit der angegebenen Dateimodus-Erstellungsmaske (Umask) aufrufen.
.I Maske
muss eine Oktalzahl sein.
Bei besonders sensiblen Daten ist zum Beispiel der Wert 027 oder gar 077 empfehlenswert.
.PP
.TP
.RI "-u " Nutzerkennung
.TQ
.RI --Nutzer= Nutzerkennung
Wenn der Server mit root-Rechten gestartet wird (reale Nutzerkennung),
kann man \[:u]ber diese Option eine andere
.I Nutzerkennung
angeben, mit deren Rechten er letztendlich laufen soll.
Die
.I Nutzerkennung
kann ein Name, oder eine nummerische Angabe sein.
.PP
.TP
-D
.TQ
--daemon
Startet den HTTP-Server als Daemon im Hintergrund.
.PP
.TP
-b
.TQ
--writable
.TQ
--beschreibbar
.B Vorsicht!
Das sollte nicht auf \[:o]ffentlichen Servern verwendet werden!
.IP
Macht das exportierte Verzeichnis und Unterverzeichnisse beschreibbar.
Es k\[:o]nnen Dateien hochgeladen (PUT) und entfernt (DELETE) werden.
.IP
Dieser Server wird nicht wirklich Dateien l\[:o]schen, sondern legt
Sicherheitskopien an, wenn Dateien entfernt oder bevor sie
\[:u]berschrieben werden. Diese Sicherheitskopien sind \[:u]ber den
Server nicht mehr zug\[:a]nglich.
Der Server-Betreiber kann sie wieder herstellen, oder l\[:o]schen.
Er sollte sie regelm\[:a]\[ss]ig l\[:o]schen, sonst h\[:a]ufen die
sich an.
.PP
.TP
-P
.TQ
--writeprotected
.TQ
--Schreibschutz
.B Vorsicht!
Das sollte nicht auf \[:o]ffentlichen Servern verwendet werden!
.IP
wie bei --beschreibbar, aber Schreibzugriffe werden mit Zugangsdaten
gesch\[:u]tzt.
Genauer gesagt gelten die Zugangsdaten hierbei nur f\[:u]r Schreibzugriffe
mit PUT oder DELETE,
w\[:a]hrend sie ansonsten f\[:u]r alle Zugriffe gelten.
.IP
.B Achtung:
Dieser Schreibschutz betrifft nicht CGI-Programme!
.PP
.TP
.RI --protected-zone= Verzeichnis
.TQ
.RI --Schutzbereich= Verzeichnis
Wenn ein Schutzbereich definiert ist, werden Zugangsdaten f\[:u]r dieses
.I Verzeichnis
und dessen Unterverzeichnisse ben\[:o]tigt.
Das
.I Verzeichnis
muss mit einem Schr\[:a]gstrich beginnen.
Wenn nur ein Schr\[:a]gstrich angegeben ist,
werden die Zugangsdaten immer ben\[:o]tigt.
Es kann zwar nur ein einziges
.I Verzeichnis
als Schutzbereich deklariert werden,
aber dieser Bereich kann in beliebig viele Unterverzeichnisse
eingeteilt werden.
Diese Einstellung gilt f\[:u]r alle virtuellen Hosts.
Diese Option kann nicht zusammen mit --Schreibschutz verwendet werden.
.IP
Es k\[:o]nnen personalisierte Unterverzeichnisse angelegt werden.
Diese fangen mit einer Tilde (~) an, gefolgt vom ben\[:o]tigten Benutzernamen.
.IP
Bitte die Hinweise im Abschnitt \[Fc]Zugangsdaten\[Fo] beachten.
.PP
.TP
-B
.TQ
--block-protected-zone
.TQ
--Schutzbereichsblockierung
Der Schutzbereich wird blockiert.
.br
Man benutze dies, wenn der Server unverschl\[:u]sselt angeboten wird,
aber auch gleichzeitig verschl\[:u]sselt ohne Blockierung.
Die betrifft auch die Option --Schreibschutz.
.PP
.TP
.RI --account= Name:Kennung
.TQ
.RI --Zugang= Name:Kennung
Legt Zugangsdaten fest.
.IP
Diese Option kann mehrfach verwendet werden,
um mehrere Zug\[:a]nge zu erlauben.
Bitte die Hinweise im Abschnitt \[Fc]Zugangsdaten\[Fo] beachten.
.PP
.TP
--open
.TQ
--offen
.TQ
--Internet
.B Vorsicht!
Das schaltet den Filter f\[:u]r private Netzwerke ab.
Der Server ist dann auch \[:u]ber das Internet erreichbar,
wenn der Zugang nicht \[:u]ber -l oder -a eingeschr\[:a]nkt wurde.
Man muss daf\[:u]r eventuell auch den Port an seinem Router freigeben.
.IP
Es besteht die Gefahr, dass dadurch ausversehen Daten
\[:o]ffentlich zug\[:a]nglich gemacht werden,
die nicht daf\[:u]r vorgesehen sind.
[IP]
.TP
--hostname
ermittle die Namen der anfragenden Rechner
.IP
Die Namen werden dann im Logbuch verwendet
und stehen f\[:u]r CGI-Programme zur Verf\[:u]gung
(REMOTE_HOST).
.IP
Dies kostet Zeit und ist im offenen Internet kaum brauchbar.
F\[:u]r lokale Netzwerke kann es aber sehr sinnvoll sein,
insbesondere, wenn alle Namen beim Server
in der Datei hosts(5) eingetragen sind.
.PP
.TP
.RI "-H " Kopfeile
.TQ
.RI --header= Kopfzeile
.TQ
.RI --Kopf= Kopfzeile
HTTP-Kopfzeile hinzuf\[:u]gen.
Diese Option kann mehrfach verwendet werden.
.IP
.B Vorsicht:
Es wird nicht gepr\[:u]ft, ob diese Kopfzeilen mit anderen
in Konflikt stehen.
.PP
.TP
.RI --var= VARIABLE = Wert
Metavariable hinzuf\[:u]gen.
Diese Option kann mehrfach verwendet werden.
.IP
Beispiel:
--var=SERVER_ADMIN=webmaster@example.net
.PP
.TP
--servicemode
.TQ
--Wartungsmodus
Im Wartungsmodus wird grunds\[:a]tzlich nur eine Fehlerseite
angezeigt, die besagt, dass der Server au\[ss]er Betrieb ist,
da daran gearbeitet wird.
(HTTP-Status 503)
TRACE-Anfragen sind erlaubt und werden normal durchgef\[:u]hrt.
.IP
Der Wartungsmodus kann auch \[:u]ber das Signal USR1 aktiviert werden,
und mit USR2 deaktivert werden.
.PP
.TP
-T
.TQ
--trace
Erlaube die Methode TRACE.
.PP
.TP
.RI "-S " Sprache
.TQ
.RI --language= Sprache
.TQ
.RI --Sprache= Sprache
Legt die
.I Sprache
f\[:u]r lokale Textausgaben, bzw. das Logbuch fest.
G\[:u]ltige Werte sind \[Fc]de\[Fo] oder \[Fc]en\[Fo].
Diese Einstellung hat keine Auswirkung auf generierte Webseiten.
.PP
.TP
.RI --tmpdir= Verzeichnis
Dieses Verzeichnis wird benutzt, um POST-Daten zwischenzuspeichern.
Es w\[:a]re vorteilhaft, wenn das Verzeichnis im Arbeitsspeicher liegt
(z.B. mit mfs oder tmpfs).
.IP
Falls die zu erwartende Datenmenge bekannt ist und dort nicht genug
Platz frei ist, versucht er es nochmal unter \[Fc]/var/tmp\[Fo].
.PP
.TP
.RI --onion= http://[...].onion
.TQ
.RI --Onion= http://[...].onion
Onion-Service bekannt geben (Onion-Location)
.IP
Das funktioniert nur, wenn der Server auch \[:u]ber HTTPS
erreichbar ist.
.PP
.TP
-i
.TQ
--inetd
Nimmt Anfragen auf der Standardeingabe entgegen
und gibt Antworten auf der Standardausgabe aus.
Wenn die Standardeingabe ein Socket ist, k\[:o]nnen daraus die
Verbindungsdaten ausgelesen werden.
.PP
.
.SH UMGEBUNGSVARIABLEN
.TP
TMPDIR
Dieses Verzeichnis wird benutzt, um POST-Daten zwischen zu speichern.
Wenn diese Variable nicht gesetzt ist, wird
.I /tmp
verwendet.
Es w\[:a]re vorteilhaft, wenn das Verzeichnis im Arbeitsspeicher liegt.
(Z.B. mit mfs oder tmpfs.)
.PP
.TP
HOSTNAME, HOST
Falls diese Variable gesetzt ist, wird das als Servername genommen.
.pp
.TP
LC_ALL, LC_MESSAGES, LANG
diese Variablen beeinflussen die Sprachauswahl f\[:u]r den Bildschirm,
oder die Logdatei (Deutsch oder Englisch).
Sie haben keinen Einfluss auf generierte Webseiten.
.PP
.
.SH NOTIZEN
.
Das Wurzelverzeichnis und alle Unterverzeichnisse werden exportiert.
In \[:u]bergeordnete Verzeichnisse kommt man nicht, es sei
denn, wenn symbolische Links nach au\[ss]erhalb verweisen.
(CGI-Programme unterliegen jedoch nicht dieser Einschr\[:a]nkung.)
.PP
Wenn ein Verzeichnis abgerufen wird, wird erstmal nach
Dateien namens
.BR index.xhtml ", " index.html " oder " index.cgi
gesucht.
Wenn diese Dateien nicht existieren, wird automatisch
ein Verzeichnisindex generiert.
Symbolische Links werden als normale Dateien, bzw. Verzeichnisse
angezeigt.
.PP
Dateien oder Verzeichnisse, deren Namen mit
.B .ht
beginnen, sind \[:u]berhaupt nicht abrufbar.
Dateien, die mit einer Tilde oder auf
.B .bak
enden, ebenfalls nicht.
Der Server tut so, als seien diese Dateien nicht vorhanden (404).
Der Zugang zu Ger\[:a]tetreibern, FIFOs und Sockets ist gesperrt (403).
.PP
Reine Textdateien sollten die Dateiendung
.B .text
oder
.B .txt
tragen.
Der Server geht davon aus, dass diese Dateien in der Kodierung
.B UTF-8
vorliegen.
Wenn man wirklich Textdateien in unterschiedlichen Kodierungen verwenden will,
kann man die Dateiendungen
.B .l1
f\[:u]r Latin1,
.B .koi8
f\[:u]r KOI8-R,
oder
.B .utf8
f\[:u]r UTF-8 verwenden.
.PP
.
.SS Grundlegende F\[:a]higkeiten
.
Der Server unterst\[:u]tzt IPv6, IPv4 und Unix-Sockets.
Es wird grunds\[:a]tzlich HTTP/1.1 unterst\[:u]tzt.
Alte HTTP/0.9-Anfragen werden aber ebenfalls noch verarbeitet,
au\[ss]er bei virtuellem Hosting.
Mit HTTP/1.x sind folgende Methoden anwendbar:
GET, HEAD, POST, OPTIONS, TRACE.
Mit der Option --beschreibbar k\[:o]nnen zus\[:a]tzlich
PUT und DELETE verwendet werden.
Persistente Verbindungen werden bevorzugt.
Mit
.I Range
kann man f\[:u]r statische Dateien Teilbereiche in Bytes anfordern.
Es werden bedingte Anfragen aufgrund des \[:A]nderungsdatums
unterst\[:u]tzt (jedoch keine ETags).
.PP
.
.SS root-Rechte
.
Wenn der Server mit root-Rechten aufgerufen wurde, kann er diese nutzen,
um sich an privilegierte Ports zu binden. Insbesondere auch der
Standard-Port f\[:u]r HTTP \- Port 80 \- erfordert root-Rechte.
In diesem Fall braucht auch die Konfigurationsdatei nur f\[:u]r root lesbar
zu sein.  Das ist vor allem wichtig, falls dort Zugangsdaten verzeichnet
sind.
.PP
Der Server wird aber root-Rechte absch\[:u]tteln, bevor er Verbindungen
entgegen nimmt.
Man kann mit der Option
.B -u
bestimmen, mit welchen Rechten der Server danach laufen soll.
Ansonsten wird er versuchen zu ermitteln, von welchem Benutzer er
wirklich aufgerufen wurde und im Zweifel die Nutzerkennung
\[Fc]nobody\[Fo] annehmen.
Wenn das alles nicht gelingt, bricht er mit einer Fehlermeldung ab.
.PP
.
.SS Frontends
.
F\[:u]r Frontends wird der Header
X-Forwarded-For
unterst\[:u]tzt, sowie das
Proxy-Protokoll, Version 1.
Letzteres muss immer erst aktiviert werden.
.PP
.
.SS Beispielkonfiguration f\[:u]r stunnel
Wenn man zum Beispiel HTTPS verwenden will, kann man das Programm
stunnel
.B <https://www.stunnel.org>
verwenden. Um die IP-Adresse des Aufrufers zu erhalten, muss man in der
Konfigurationsdatei von stunnel den Parameter \[Fc]protocol = proxy\[Fo]
setzen.
.PP
Im folgenden Beispiel m\[:u]ssen die Pfade angepasst werden.
.PP
.EX
[https]
accept   = 443
connect  = /var/run/www/https
protocol = proxy
cert     = /etc/letsencrypt/live/example.net/fullchain.pem
key      = /etc/letsencrypt/live/example.net/privkey.pem
.EE
.
.SS Zugangsdaten
.
Zugangsdaten k\[:o]nnen im Wurzelverzeichnis in einer Datei namens 
.RB \[Fc] .htZugang \[Fo]
eingetragen werden.
Der Dateiname muss mit einem Punkt beginnen.
Diese Datei wird zur Laufzeit gelesen,
kann also ver\[:a]ndert werden.
Die Zugriffsrechte sollten eingeschr\[:a]nkt sein.
Leerzeilen und Zeilen, die mit einer Raute (#) beginnen,
werden ignoriert.
.PP
Zugangsdaten k\[:o]nnen auch \[:u]ber die Option
.I --Zugang Name:Kennung
angegeben werden.
Diese Daten sind f\[:u]r alle virtuellen Hosts gleich
und um sie zu \[:a]ndern, muss der Server neu gestartet werden.
.PP
F\[:u]r Namen und Kennungen darf man nur reine ASCII-Zeichen verwenden;
also keine deutschen Umlaute, oder andere Sonderzeichen.
Allgemeine Satzzeichen sind aber erlaubt.
Leerzeichen sind zwar ebenfalls erlaubt, aber einige Clients
k\[:o]nnten Probleme damit haben.
.PP
Die Zugangsdaten k\[:o]nnen im Klartext,
oder verschleiert mit Base64 angegeben werden.
Verschleierte Daten kann man mit dem Programm
.BR akfnetzpass (1)
erzeugen lassen.
Wenn am Anfang ein Doppelpunkt steht, geht er davon aus, dass das
verschleiert ist.
(Wenn die Daten M\[:u]ll sind, kommt man damit halt nicht rein.)
.PP
.B Achtung:
Die Zugangsdaten werden zwar verschleiert, aber bei HTTP unverschl\[:u]sselt
\[:u]bertragen, und das nicht nur einmal, sondern immer wieder.
Die Verschleierung sch\[:u]tzt nur vor versehentlichem Mitlesen.
Ein Angreifer kann das jedoch einfach dekodieren.
Man sollte dies also nicht zur Absicherung wirklich sensibler
Daten verwenden.
Es sei denn, die \[:U]bertragung wird durch ein Frontend verschl\[:u]sselt.
.PP
Der Name darf nicht leer sein.
Zugangsdaten mit leerer Kennung sind jedoch erlaubt.
.PP
Es k\[:o]nnen personalisierte Verzeichnisse angelegt werden,
die nur von einem Benutzer betreten werden k\[:o]nnen.
Diese fangen mit einer Tilde (~) an, gefolgt vom ben\[:o]tigten Benutzernamen.
.PP
Ein CGI-Programm kann feststellen, ob eine Anmeldung erfolgte,
indem es pr\[:u]ft, ob die Variable AUTH_TYPE existiert und nicht leer ist.
Der Name ist dann in der Variablen REMOTE_USER zu finden.
Wenn Zugangsdaten mitgeschickt werden, obwohl keine Anmeldung n\[:o]tig war,
wird REMOTE_USER zugewiesen, aber AUTH_TYPE bleibt ungesetzt.
.
.SS Common Gateway Interface (CGI)
.
Dieser Server unterst\[:u]tzt CGI/1.1 (RFC\~3875).
(Er kann aber auch ohne CGI-Unterst\[:u]tzung kompiliert werden.)
Das spezielle Verzeichnis \[Fc]/cgi-bin\[Fo] wird immer besonders 
behandelt.
.PP
CGI-Programme sollten vorzugsweise im Verzeichnis \[Fc]/cgi-bin\[Fo]
abgelegt werden. Bei diesem Verzeichnis wird kein automatischer Index 
erstellt.
Ausf\[:u]hrbare Dateien in diesem Verzeichnis werden als CGI-Programme 
angesehen.
Nicht-ausf\[:u]hrbare Dateien sind hingegen nicht zug\[:a]nglich.
Dieses k\[:o]nnen Konfigurationsdateien oder Daten f\[:u]r CGI-Programme 
sein. Auch Unterverzeichnisse sind nicht zug\[:a]nglich.
.PP
Mit den Optionen
.IR --cgi " oder " --cgi-Datei
k\[:o]nnen weitere Dateien als CGI-Programme ausgewiesen werden.
.PP
Das Arbeitsverzeichnis wird auf das Verzeichnis gesetzt,
in dem das CGI-Programm liegt. Also in der Regel \[Fc]/cgi-bin\[Fo].
.PP
Folgende Variablen werden gem\[:a]\[ss] der Spezifikation unterst\[:u]tzt:
AUTH_TYPE, CONTENT_LENGTH, CONTENT_TYPE, GATEWAY_INTERFACE, PATH_INFO,
PATH_TRANSLATED, QUERY_STRING, REMOTE_ADDR, REMOTE_HOST, REMOTE_USER,
REQUEST_METHOD, SCRIPT_NAME, SERVER_NAME, SERVER_PORT, SERVER_PROTOCOL,
SERVER_SOFTWARE,
sowie Protokoll-spezifische Variablen, die mit \[Fc]HTTP_\[Fo] eingeleitet
werden.
.PP
Die Variable REMOTE_HOST wird nur gesetzt, wenn die Option --hostname
verwendet wurde.
.PP
Die Variable REMOTE_ADDR bekommt den Wert \[Fc]127.0.0.1\[Fo] zugewiesen,
wenn die IP-Adresse nicht zur Verf\[:u]gung steht.
.PP
Die Variable REMOTE_IDENT bleibt ungesetzt,
was laut Spezifikation erlaubt ist.
Daf\[:u]r werden aber auch einige zus\[:a]tzliche Variablen definiert.
Programme, die mit anderen Servern laufen k\[:o]nnen sollen,
sollten sich jedoch auf die oben genannten Variablen beschr\[:a]nken.
.PP
Erweiterungen:
DOCUMENT_ROOT, REQUEST_URI, REMOTE_PORT, REDIRECT_STATUS, REDIRECT_URL
.PP
Die Ausgabe des Programmes erfolgt auf der Standardausgabe.
Sie muss zun\[:a]chst
einen CGI-Kopf enthalten, dann eine Leerzeile, dann evtl. der Inhalt.
Der Kopf muss aus mindestens einer Zeile bestehen.
Wenn ein Inhalt folgt, muss der Content-Type angegeben werden.
Zum Beispiel \[Fc]Content-Type: text/plain; charset=UTF-8\[Fo].
Oft reicht auch nur diese eine Zeile.
Besondere Bedeutung bei CGI haben die Zeilen \[Fc]Status:\[Fo],
\[Fc]Location:\[Fo] und \[Fc]Content-Type:\[Fo].
Dar\[:u]ber hinaus k\[:o]nnen die meisten HTTP-Angaben auch als
CGI-Kopfzeilen verwendet werden und werden einfach weitergeleitet.
.PP
CGI-Kopfzeilen, die mit \[Fc]X-CGI-\[Fo] beginnen, werden ignoriert,
und nicht weitergeleitet.
Wenn die Variable REQUEST_METHOD den Wert
.B HEAD
hat, sollte das Programm nur den Kopf ausgeben und keinen Inhalt.
.PP
Fehlerausgaben des Programmes werden verworfen (/dev/null).
Kommandozeilenparamter (IsIndex) sind auf 50 beschr\[:a]nkt.
.PP
Wenn Daten mit der Methode POST \[:u]bertragen werden,
werden diese in einer tempor\[:a]ren Datei gespeichert
und stehen auf der Standardeingabe zur Verf\[:u]gung.
Die Standardeingabe kann bei diesem Server per
.BR mmap (2)
eingebunden werden.
Die Gr\[:o]\[ss]e der Daten steht in der Variablen CONTENT_LENGTH
und der Typ in CONTENT_TYPE.
.PP
F\[:u]r NPH-Skripte muss der Dateiname mit dem Pr\[:a]fix
.B nph-
anfangen.
.PP
PHP kann \[:u]ber die CGI-Schnittstelle angebunden werden.
Das ist zwar nicht ideal, aber es funktioniert.
Hierf\[:u]r muss man mit der Option
.I --Erweiterung
die Dateierweiterung
.B php
mit dem CGI-Programm f\[:u]r PHP verkn\[:u]pfen.
Die Sicherheitsma\[ss]nahme
.I cgi.force_redirect
wird unterst\[:u]tzt und sollte in PHP aktiviert sein.
.
.
.SH AUTOREN
.
Copyright \(co 2015-2025 Andreas K. F\[:o]rster
.
.SH LIZENZ
.
Dieses Programm ist freie Software.
Sie k\[:o]nnen es unter den Bedingungen
der GNU General Public License, wie von der Free Software Foundation
ver\[:o]ffentlicht, weitergeben und/oder modifizieren,
entweder gem\[:a]\[ss]
Version 3 der Lizenz oder (nach Ihrer Option)
jeder sp\[:a]teren Version.
.PP
Die Ver\[:o]ffentlichung dieses Programms erfolgt in der Hoffnung,
dass es Ihnen von Nutzen sein wird, aber
.BR "ohne irgendeine Garantie" ,
sogar ohne die implizite Garantie der
.B Marktreife
oder der
.BR "Verwendbarkeit f\[:u]r einen bestimmten Zweck" .
Details finden Sie in der GNU General Public License.
.PP
Sie sollten ein Exemplar der GNU General Public License zusammen
mit diesem Programm erhalten haben.
Falls nicht, siehe <http://www.gnu.org/licenses/>.
.
.SS Anmerkung
.
Auf CGI-Programme, die mit diesem Server ausgef\[:u]hrt werden,
hat diese Lizenz erstmal keinen Einfluss.
Allerdings bietet akfnetz auch Funktionen zum Schreiben
von CGI-Programmen unter C, oder kompatiblen Sprachen.
Wenn man diese Funktionen verwendet, muss das CGI-Programm
unter der gleichen Lizenz stehen, oder einer Nachfolgeversion;
unabh\[:a]ngig davon, mit welchem Server es eingesetzt wird.
.PP
.
.SH "SIEHE AUCH"
.BR akfnetzpass (1),
.BR akfweb-dl (1),
.BR akfquery (1),
.BR lynx (1)
.PP
https://akfoerster.de/p/akfnetz/
