.\" Process this file with
.\" groff -man -Tutf8 akfweb-dl.de.man
.\"
.
.TH "akfweb-dl" 1 2024-07-05 akfnetz
.nh
.
.\" Makros .TQ .EX .EE aus groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.de TQ
.br
.ns
.TP \\$1
..
.
.\" Start example.
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" End example.
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.SH NAME
.
akfweb-dl \- Ladeprogramm f\[:u]r HTTP
.
.SH SYNTAX
.
.BI "akfweb-dl [" Optionen "] [" "Datei ..." "] <" URL >
.
.SH BESCHREIBUNG
.
Dies ist ein einfaches Ladeprogramm f\[:u]r HTTP.
.PP
Es kann z.B. als Backend von anderen Programmen aus aufgerufen werden,
um Informationen oder anderes Material aus dem Internet nachzuladen.
.PP
Das Programm ist zweisprachig: Deutsch und Englisch.
.PP
.
.SH OPTIONEN
.TP
-h
.TQ
--help
.TQ
--Hilfe
Zeigt eine kurze Hilfe an.
.TP
-V
.TQ
--version
.TQ
--Version
Zeigt die Version an.
.PP
.TP
-i
.TQ
--info
Nur Infos \[:u]ber die Adresse auf der Standard-Fehlerausgabe ausgeben.
Dies geschieht \[:u]ber eine
.IR HEAD -Anfrage.
.PP
.TP
-I
.TQ
--head
Wie --info, aber HTTP-Kopf ungefiltert ausgeben.
.PP
.TP
-O
.TQ
--Optionen
.TQ
--options
Wie --head, aber mit der Methode
.IR OPTIONS .
.PP
.TP
-c
.TQ
--stdout
Den Inhalt \[:u]ber die Standardausgabe ausgeben,
anstatt sie in eine Datei zu speichern.
Sonstige Ausgaben erfolgen \[:u]ber die Fehlerausgabe.
.PP
.TP
.RI "-o " \[dq]Dateiname\[dq]
.TQ
.RI "--output=" \[dq]Dateiname\[dq]
.TQ
.RI "--Ausgabe=" \[dq]Dateiname\[dq]
.TQ
.RI "--Datei=" \[dq]Dateiname\[dq]
Dies als
.I Dateiname
verwenden.
Wenn bereits eine Datei mit diesem
.IR Dateiname n
besteht, bricht das Programm mit einer Fehlermeldung ab.
Wird als
.I Dateiname
nur ein Minus-Zeichen (-) angegeben, erfolgt die Ausgabe
\[:u]ber die Standardausgabe, wie bei -c.
.PP
.RI "-a " \[dq]Dateiname\[dq]
.TQ
.RI "--aktualisiere=" \[dq]Dateiname\[dq]
Aktualisiere
.IR Dateiname .
Wenn die Datei bereits besteht, wird die \[:A]nderungszeit an
den Server \[:u]bermittelt mit der Bitte die Datei nur zu
\[:u]bertragen, wenn sie auf dem Server neuer ist.
In dem Fall wird die Datei \[:u]berschrieben.
(Server, die diese Funktion nicht vollst\[:a]ndig unterst\[:u]tzen,
werden die Datei immer \[:u]bertragen.)
.PP
.TP
-S
Neu angelegte Dateien sollen nur f\[:u]r den Benutzer zug\[:a]nglich sein,
falls m\[:o]glich.
(Das entspricht \[Fc]umask 0077\[Fo])
Das sollte man verwenden, wenn man z.\~B. tempor\[:a]re Dateien
in /tmp/ anlegt.
.br
.B Achtung:
Das funktioniert aber nicht mit allen Betriebssystemen und Dateisystemen.
.PP
.TP
--gzip
Akzeptiere komprimierte Dateien.
Es gibt aber keine Garantie, dass der Server das komprimiert schickt.
Der Dateiname wird angepasst, indem ein .gz oder .Z angef\[:u]gt wird.
Das Programm gzip kann beides entkomprimieren.
.TP
-L
.TQ
--entfernen
.TQ
--delete
Bitte den Server darum, die angegebene Adresse unzug\[:a]nglich zu machen.
In den meisten F\[:a]llen wird der Server eine solche Bitte jedoch nur
mit einer h\[:o]hnischen Fehlermeldung quittieren.
.PP
.TP
-u
.TQ
--cp
.TQ
--senden
.TQ
--upload
Versuche die angegebenen Dateien an die Adresse zu senden,
falls der Server das erlaubt.
Wenn bereits entsprechende Dateien auf dem Server liegen
und \[:a]lter sind, werden diese ersetzt.
Die Zieladresse wird am Schluss angegeben, wie bei
.IR cp .
.IP
Die angegebene Adresse sollte mit einem Schr\[:a]gstrich enden.
Dann werden die Dateinamen (ohne Pfad) angeh\[:a]ngt.
Wenn nur eine einzelne Datei gesendet werden soll, darf die
Adresse mit einem neu zu verwendenden Dateinamen enden.
.PP
.TP
-s
.TQ
--still
nur das N\[:o]tigste ausgeben
.PP
.TP
-l
.TQ
--links
.TQ
--Links
Gibt eine Liste der Links aus HTML-Code auf der Standardausgabe aus.
Das ist vor allem bei Adressen von Verzeichnissen n\[:u]tzlich.
.PP
.TP
-U
.TQ
--nicht-umleiten
Umleitungen als Fehler behandeln
.PP
.TP
-M
.TQ
--nicht-interaktiv
nicht interaktiv nach Zugangsdaten fragen
.PP
.TP
-N
.TQ
--nohup
Das Signal HUP ignorieren.
Die Optionen -s und -M werden implizit mit gesetzt.
Dies ist n\[:u]tzlich f\[:u]r l\[:a]ngere Downloads auf einem entfernten System,
wenn man das Programm im Hintegrund startet und sich danach ausloggen will.
.TP
.RI "-Z " \[dq]Name:Kennung\[dq]
.TQ
.RI --Zugang= \[dq]Name:Kennung\[dq]
Zugangsdaten mitschicken.
Die Zugangsdaten k\[:o]nnen im Klartext
oder Base64-kodiert angegeben werden.
Diese Option sollte mit Vorsicht verwendet werden.
Es gibt bessere M\[:o]glichkeiten Zugangsdaten anzugeben.
.PP
.TP
.RI "-P " "http://[Name:Kennung@]Host:Port/"
.TQ
.RI "--proxy=" "http://[Name:Kennung@]Host:Port/"
.TQ
.RI "--Proxy=" "http://[Name:Kennung@]Host:Port/"
Proxy verwenden.
Unterst\[:u]tzte Protokolle: http, socks4, socks4a, socks5, socks5h.
Das kann auch \[:u]ber Umgebungsvariablen angegeben werden.
Mit --proxy="" kann man verhindern, dass ein Proxy
verwendet wird.
.PP
.TP
-t
.TQ
--tor
Tor verwenden.
Das ist eine Kurzform von
\[Fc]-P socks4a://127.0.0.1:9050/\[Fo].
Es funktioniert nur wenn Tor installiert ist,
jedoch nicht mit dem Tor-Browser.
.PP
.TP
.RI --socket= Socketpfad
.TQ
.RI --Socket= Socketpfad
Verbindung \[:u]ber lokalen Socket herstellen.
Das kann ein Server oder ein HTTP-Proxy sein.
.PP
.TP
.RI "-r " URL
.TQ
.RI "--referrer=" URL
verweisende
.I URL
angeben
.PP
.TP
.RI "-A " \[dq]Name\[dq]
.TQ
.RI "--user-agent=" \[dq]Name\[dq]
Verwende
.I Name
als Angabe f\[:u]r den User-Agent.
Diese Angabe ist zum Beispiel f\[:u]r Statistiken interessant.
Das kann auch \[:u]ber eine Umgebungsvariable angegeben werden.
.PP
.TP
.RI "-m " "E-Mail-Adresse"
.TQ
.RI "--mail=" "E-Mail-Adresse"
Kontakt-Adresse mitschicken.
Diese Option sollte man verwenden, wenn man einen Bot schreibt.
\[:U]ber diese Adresse kann man sich dann \[:u]ber das Teil beschweren.
Das kann auch \[:u]ber eine Umgebungsvariable angegeben werden.
.PP
.TP
-T
.TQ
--trace
Gibt auf der Standardausgabe aus, wie die Anfrage beim Server angekommen ist.
Damit sieht man zum Beispiel auch Angaben \[:u]ber welche Proxies das lief.
Das wird leider nicht von jedem Server unterst\[:u]tzt.
.PP
.TP
-4
.TQ
--IPv4
.TQ
-6
.TQ
--IPv6
Auf IPv4 oder IPv6 einschr\[:a]nken.
Ansonsten wird beides durchprobiert.
Bei Verwendung eines Proxys
bezieht sich das nur auf die Verbindung zu diesem.
.PP
.
.SH UMGEBUNGSVARIABLEN
.
.TP
all_proxy
.TQ
ALL_PROXY
.TQ
http_proxy
Proxy verwenden.
.IP
Die Angabe erfolgt in Form einer URL,
.br
zum Beispiel:
.IR http://127.0.0.1:8080/ ,
.br
oder mit Zugangsdaten:
.IR http://Name:Kennung@127.0.0.1:8080/ .
.IP
Es wird auch SOCKS 4, 4a und 5h unterst\[:u]tzt.
.br
Zum Beispiel:
.IR socks5h://Name:Kennung@127.0.0.1:1080/ .
.IP
Dieses Programm behandelt derzeit socks5 als Alias f\[:u]r socks5h.
Zugangsdaten werden unverschl\[:u]sselt \[:u]bertragen.
SOCKS 4 und 4a unterst\[:u]tzen gar keine Zugangsdaten,
aber da wird die Nutzerkennung \[:u]bertragen (LOGNAME).
.IP
Manche Server k\[:o]nnen ausgetrickst werden, dass sie
bei CGI oder PHP die Umgebungsvariable HTTP_PROXY erzeugen.
Darum wird sie hier nicht gro\[ss]geschrieben erlaubt.
.PP
.TP
HTTPSOCKET
Verbindung \[:u]ber einen lokalen Unix-Socket mit dem
angegebenen Pfad herstellen.
Das kann ein Server oder ein HTTP-Proxy sein.
.PP
.TP
AKFUSERAGENT
Angabe f\[:u]r den User-Agent
.PP
.TP
AKFAGENTMAIL
Kontakt-Adresse mitschicken
.PP
.TP
LC_ALL, LC_MESSAGES, LANG
anhand dieser Variablen wird entschieden,
ob die Ausgabe auf deutsch erfolgt.
.PP
.TP
HOME
Heimatverzeichnis des Benutzers.
Hier wird die Datei
.I .netrc
gesucht.
.
.SH DATEIEN
.
.TP
~/.netrc
Zugangsdaten f\[:u]r verschiedene Server.
Die Datei darf nur f\[:u]r den Benutzer lesbar sein.
Siehe
.BR netrc (5).
.
.SH NOTIZEN
.
Der Dateiname wird normalerweise aus der URL hergeleitet.
Falls die URL auf / endet, wird die Datei \[Fc]index.html\[Fo] genannt.
Bestehende Dateien werden nicht \[:u]berschrieben.
.PP
.B Achtung:
Falls eine Umleitung erfolgt, ist der automatisch gew\[:a]hlte
Dateiname nicht unbedingt der, den man erwartet.
In Skripten ist es somit empfehlenswert, den Dateinamen mit der Option
.I -o
vorzugeben, oder die Standardausgabe zu verwenden.
.PP
Internationale Domainnamen (IDN oder \[Fc]Umlaut-Domains\[Fo]) werden leider
nicht unterst\[:u]tzt.
Stattdessen muss man die ASCII-Darstellung (ACE-Form, A-Label) verwenden.
Zum Beispiel statt \[Fc]http://akf\[:o]rster.de/\[Fo] muss man
\[Fc]http://xn--akfrster-p4a.de/\[Fo] verwenden.
.PP
HTTPS, dh. verschl\[:u]sselte Verbindungen werden nicht unterst\[:u]tzt;
Webseiten, die HTTPS erzwingen, somit ebenfalls nicht.
.PP
F\[:u]r die Autorisierung wird nur die Methode
.B Basic
unterst\[:u]tzt.
Die Zugangsdaten k\[:o]nnen \[:u]ber die Datei
.I ~/.netrc
angegeben werden.
Ansonsten werden sie interaktiv abgefragt, wenn nicht die Option
.I -M
oder
.I -Z
verwendet wurde.
Zugangsdaten f\[:u]r einen Proxy werden jedoch nicht interaktiv abgefragt.
.B Achtung:
Diese Zugangsdaten werden unverschl\[:u]sselt \[:u]bertragen.
.PP
.B Wichtig:
Falls man automatisiert mehrere Dateien von einem \[:o]ffentlichen
Server laden will, sollte man eine Wartezeit von vielleicht zwei
Sekunden zwischen den Downloads einrichten, um den Server nicht
zu stark zu belasten!
Denkt daran, dass ihr wohl nicht die einzigen sein werdet,
die auf den Server zugreifen; und auch nicht die einzigen,
die das automatisiert tun.
Nach M\[:o]glichkeit sollte man auch die Angaben der Datei
.I /robots.txt
von dem Server beachten.
.PP
Bei jeder Anfrage erfolgt auch eine DNS-Anfrage.
Es wird dringend empfohlen einen DNS-Cache-Server zu benutzen.
(In Routern ist sowas aber oft schon eingebaut.)
.PP
Bei Verwendung eines HTTP-Proxies oder bei SOCKS 4a und 5h erfolgt die
Namensaufl\[:o]sung \[:u]ber den Proxy.
(Bei diesem Programm ist socks5 ein Alias f\[:u]r socks5h.)
.PP
Domains, die auf \[Fc].onion\[Fo] enden, werden nie per DNS abgefragt.
Bei Verwendung von Tor sind sie aber benutzbar.
.PP
.
.SH BEKANNTE PROBLEME
.
Bei der Datei
.I .netrc
ist es prinzipbedingt nicht m\[:o]glich Namen oder Passw\[:o]rter mit
Leerzeichen oder Tabs zu verwenden.
Das Format ist aber altbekannt und wird auch von anderer Software
verwendet.  Darum will ich daran nichts \[:a]ndern.
.
.SH AUTOREN
.
Copyright \(co 2015-2022 Andreas K. F\[:o]rster
.PP
Dieses Programm ist freie Software.
Sie k\[:o]nnen es unter den Bedingungen
der GNU General Public License, wie von der Free Software Foundation
ver\[:o]ffentlicht, weitergeben und/oder modifizieren,
entweder gem\[:a]\[ss]
Version 3 der Lizenz oder (nach Ihrer Option)
jeder sp\[:a]teren Version.
.PP
Die Ver\[:o]ffentlichung dieses Programms erfolgt in der Hoffnung,
dass es Ihnen von Nutzen sein wird, aber
.BR "ohne irgendeine Garantie" ,
sogar ohne die implizite Garantie der
.B Marktreife
oder der
.BR "Verwendbarkeit f\[:u]r einen bestimmten Zweck" .
Details finden Sie in der GNU General Public License.
.PP
Sie sollten ein Exemplar der GNU General Public License zusammen
mit diesem Programm erhalten haben.
Falls nicht, siehe <http://www.gnu.org/licenses/>.
.PP
.
.SH "SIEHE AUCH"
.BR netrc (5),
.BR akfwebserver (1)
.BR akfgopher-dl (1),
.BR curl (1),
.BR wget (1),
.PP
https://akfoerster.de/p/akfnetz/
