.\" Process this file with
.\" groff -man -Tutf8 akfquery.en.man
.\"
.
.TH "akfquery" 1 2024-09-22 akfnetz
.nh
.
.\" Makros .TQ .EX .EE aus groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.de TQ
.br
.ns
.TP \\$1
..
.
.\" Beispielanfang
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" Beispielende
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.SH NAME
akfquery \- use form data via CGI in shell scripts
.
.SH SYNOPSIS
.B akfquery
.I field_name
.RI [ alternative ]
.
.SH DESCRIPTION
With the program
.B akfquery
you can use forms with the
.BR GET -method
in shell scripts.
.PP
A
.I field_name
must be provided.
The program outputs the decoded field value to the standard output.
If the field doesn't exist or if it is empty, then it outputs the
.IR alternative ,
if given.
Otherwise the output is empty.
.PP
If the field has multiple values, the program outputs multiple lines.
This can happen for example with checkboxes.
.PP
Special HTML-characters (<>&"') are converted to HTML-enities.
.
.SS Warning
.
Shell scripts are suitable for quick temporary solutions or drafts
in local, private networks.
But they shouldn't be used for productive work on the open Internet.
.
.SH ENVIRONMENT
.TP
QUERY_STRING
contains the form data with the method GET
.
.SH EXAMPLES
.EX
# save in variable for reuse
name=$(akfquery name "unknown")

echo "<p>Hello $name.</p>"

# for single use output you can directly include it
# the line breaks don't really matter for HTML
echo "<p>age:"
akfquery age
echo "</p>"

# hobby is done with checkboxes
echo "<ul>"
for i in $(akfquery hobby "no hobbys")
do
  echo "<li>$i</li>"
done
echo "</ul>"
.EE
.
.SH AUTHORS
.
Copyright \(co 2018 Andreas K. F\[:o]rster
.PP
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.
.PP
This program is distributed in the hope that it will be useful, but
.BR "WITHOUT ANY WARRANTY" ;
without even the implied warranty of
.BR MERCHANTABILITY " or " "FITNESS FOR A PARTICULAR PURPOSE" .
See the GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program.
If not, see <http://www.gnu.org/licenses/>.
.PP
.
.SH "SEE ALSO"
.BR akfwebserver (1)
.PP
https://akfoerster.de/p/akfnetz/
